/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.toml;

import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.core.utils.StringUtils;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.util.Iterator;

final class StringWriter {
    private static final char[] ESCAPED_B = new char[]{'\\', 'b'};
    private static final char[] ESCAPED_F = new char[]{'\\', 'f'};
    private static final char[] ESCAPED_N = new char[]{'\\', 'n'};
    private static final char[] ESCAPED_R = new char[]{'\\', 'r'};
    private static final char[] ESCAPED_T = new char[]{'\\', 't'};
    private static final char[] ESCAPED_BACKSLASH = new char[]{'\\', '\\'};
    private static final char[] ESCAPED_QUOTE = new char[]{'\\', '\"'};

    static void writeBasic(String str, CharacterOutput output) {
        output.write('\"');
        for (char c : str.toCharArray()) {
            StringWriter.writeBasicChar(c, output);
        }
        output.write('\"');
    }

    static void writeBasicMultiline(String str, CharacterOutput output, TomlWriter writer) {
        output.write("\"\"\"");
        Iterator it = StringUtils.splitLines((String)str).iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            writer.writeNewline(output);
            char[] chars = line.toCharArray();
            block7: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (c) {
                    case '\"': {
                        if (i + 1 == chars.length && !it.hasNext() || i + 1 < chars.length && chars[i + 1] == '\"' && i + 2 < chars.length && chars[i + 2] == '\"' && i + 3 < chars.length) {
                            output.write(ESCAPED_QUOTE);
                            continue block7;
                        }
                        output.write(c);
                        continue block7;
                    }
                    case '\b': {
                        output.write(ESCAPED_B);
                        continue block7;
                    }
                    case '\f': {
                        output.write(ESCAPED_F);
                        continue block7;
                    }
                    case '\\': {
                        output.write(ESCAPED_BACKSLASH);
                        continue block7;
                    }
                    default: {
                        output.write(c);
                    }
                }
            }
        }
        output.write("\"\"\"");
    }

    static void writeLiteral(String str, CharacterOutput output) {
        output.write('\'');
        output.write(str);
        output.write('\'');
    }

    static void writeLiteralMultiline(String str, CharacterOutput output) {
        output.write("'''\n");
        output.write(str);
        output.write("''''");
    }

    private static void writeBasicMultilineChar(char c, CharacterOutput output) {
    }

    private static void writeBasicChar(char c, CharacterOutput output) {
        switch (c) {
            case '\\': {
                output.write(ESCAPED_BACKSLASH);
                break;
            }
            case '\"': {
                output.write(ESCAPED_QUOTE);
                break;
            }
            case '\b': {
                output.write(ESCAPED_B);
                break;
            }
            case '\f': {
                output.write(ESCAPED_F);
                break;
            }
            case '\n': {
                output.write(ESCAPED_N);
                break;
            }
            case '\r': {
                output.write(ESCAPED_R);
                break;
            }
            case '\t': {
                output.write(ESCAPED_T);
                break;
            }
            default: {
                output.write(c);
            }
        }
    }

    private StringWriter() {
    }
}

