/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.json;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.concurrent.ConcurrentConfig;
import com.electronwill.nightconfig.core.io.CharacterInput;
import com.electronwill.nightconfig.core.io.CharsWrapper;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.core.io.ReaderInput;
import com.electronwill.nightconfig.core.io.Utils;
import com.electronwill.nightconfig.core.utils.FastStringReader;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class JsonParser
implements ConfigParser<Config> {
    private static final char[] SPACES = new char[]{' ', '\t', '\n', '\r'};
    private static final char[] TRUE_LAST = new char[]{'r', 'u', 'e'};
    private static final char[] FALSE_LAST = new char[]{'a', 'l', 's', 'e'};
    private static final char[] NULL_LAST = new char[]{'u', 'l', 'l'};
    private static final char[] NUMBER_END = new char[]{',', '}', ']', ' ', '\t', '\n', '\r'};
    private final ConfigFormat<Config> configFormat;
    private boolean emptyDataAccepted = false;
    private boolean trailingDataAccepted = false;

    public JsonParser() {
        this(JsonFormat.fancyInstance());
    }

    JsonParser(ConfigFormat<Config> configFormat) {
        this.configFormat = configFormat;
    }

    public ConfigFormat<Config> getFormat() {
        return this.configFormat;
    }

    public boolean isEmptyDataAccepted() {
        return this.emptyDataAccepted;
    }

    public JsonParser setEmptyDataAccepted(boolean emptyDataAccepted) {
        this.emptyDataAccepted = emptyDataAccepted;
        return this;
    }

    public boolean isTrailingDataAccepted() {
        return this.trailingDataAccepted;
    }

    public JsonParser setTrailingDataAccepted(boolean trailingDataAccepted) {
        this.trailingDataAccepted = trailingDataAccepted;
        return this;
    }

    public Object parseDocument(String json) {
        return this.parseDocument((Reader)new FastStringReader(json));
    }

    public Object parseDocument(Reader reader) {
        return this.parseDocument(reader, this.configFormat.createConfig());
    }

    public Object parseDocument(Reader reader, Config configModel) {
        Object result;
        ReaderInput input = new ReaderInput(reader);
        if (input.peek() == -1) {
            if (this.emptyDataAccepted) {
                return configModel.createSubConfig();
            }
            throw new ParsingException("No json data: input is empty");
        }
        char firstChar = input.readCharAndSkip(SPACES);
        if (firstChar == '{') {
            result = this.parseObject((CharacterInput)input, configModel.createSubConfig(), ParsingMode.MERGE);
        } else if (firstChar == '[') {
            result = this.parseArray((CharacterInput)input, new ArrayList(), ParsingMode.MERGE, configModel.createSubConfig());
        } else {
            throw new ParsingException("Invalid first character for a json document: " + firstChar);
        }
        int trailing = input.readAndSkip(SPACES);
        if (trailing >= 0) {
            input.pushBack((char)trailing);
            String msg = String.format("Invalid data at the end of the JSON document: %s (use JsonParser.setTrailingDataAccepted(true) if you intend this to work)", input.read(6).toString());
            throw new ParsingException(msg);
        }
        return result;
    }

    public Config parse(Reader reader) {
        Config config = this.configFormat.createConfig();
        this.parse(reader, config, ParsingMode.MERGE);
        return config;
    }

    public void parse(Reader reader, Config destination, ParsingMode parsingMode) {
        ReaderInput input = new ReaderInput(reader);
        if (input.peek() == -1) {
            if (this.emptyDataAccepted) {
                return;
            }
            throw new ParsingException("No json data: input is empty");
        }
        char firstChar = input.readCharAndSkip(SPACES);
        if (firstChar != '{') {
            throw new ParsingException("Invalid first character for a json object: " + firstChar);
        }
        if (destination instanceof ConcurrentConfig) {
            ((ConcurrentConfig)destination).bulkUpdate(arg_0 -> this.lambda$parse$0(parsingMode, (CharacterInput)input, arg_0));
        } else {
            parsingMode.prepareParsing(destination);
            this.parseObject((CharacterInput)input, destination, parsingMode);
        }
        int trailing = input.readAndSkip(SPACES);
        if (trailing >= 0) {
            input.pushBack((char)trailing);
            String msg = String.format("Invalid data at the end of the JSON document: %s (use JsonParser.setTrailingDataAccepted(true) if you intend this to work)", input.read(6).toString());
            throw new ParsingException(msg);
        }
    }

    public <T> List<T> parseList(String json) {
        return this.parseList((Reader)new FastStringReader(json));
    }

    public <T> List<T> parseList(Reader reader) {
        ArrayList list = new ArrayList();
        this.parseList(reader, list, ParsingMode.MERGE, this.configFormat.createConfig());
        return list;
    }

    public void parseList(Reader reader, List<?> destination, ParsingMode parsingMode) {
        this.parseList(reader, destination, parsingMode, this.configFormat.createConfig());
    }

    public void parseList(Reader reader, List<?> destination, ParsingMode parsingMode, Config configModel) {
        ReaderInput input = new ReaderInput(reader);
        if (input.peek() == -1) {
            if (this.emptyDataAccepted) {
                return;
            }
            throw new ParsingException("No json data: input is empty");
        }
        char firstChar = input.readCharAndSkip(SPACES);
        if (firstChar != '[') {
            throw new ParsingException("Invalid first character for a json array: " + firstChar);
        }
        this.parseArray((CharacterInput)input, destination, parsingMode, configModel);
        int trailing = input.readAndSkip(SPACES);
        if (trailing >= 0) {
            input.pushBack((char)trailing);
            String msg = String.format("Invalid data at the end of the JSON document: %s (use JsonParser.setTrailingDataAccepted(true) if you intend this to work)", input.read(6).toString());
            throw new ParsingException(msg);
        }
    }

    private <T extends Config> T parseObject(CharacterInput input, T config, ParsingMode parsingMode) {
        char kfirst = input.readCharAndSkip(SPACES);
        if (kfirst == '}') {
            return config;
        }
        if (kfirst != '\"') {
            throw new ParsingException("Invalid beginning of a key: " + kfirst);
        }
        this.parseKVPair(input, config, parsingMode);
        char vsep;
        while ((vsep = input.readCharAndSkip(SPACES)) != '}') {
            if (vsep != ',') {
                throw new ParsingException("Invalid value separator: " + vsep);
            }
            kfirst = input.readCharAndSkip(SPACES);
            if (kfirst != '\"') {
                throw new ParsingException("Invalid beginning of a key: " + kfirst);
            }
            this.parseKVPair(input, config, parsingMode);
        }
        return config;
    }

    private void parseKVPair(CharacterInput input, Config config, ParsingMode parsingMode) {
        List<String> key = Collections.singletonList(this.parseString(input));
        char sep = input.readCharAndSkip(SPACES);
        if (sep != ':') {
            throw new ParsingException("Invalid key-value separator: " + sep);
        }
        char vfirst = input.readCharAndSkip(SPACES);
        Object value = this.parseValue(input, vfirst, parsingMode, config);
        parsingMode.put(config, key, value);
    }

    private <T> List<T> parseArray(CharacterInput input, List<T> list, ParsingMode parsingMode, Config parentConfig) {
        char valueFirst;
        char next;
        boolean first = true;
        do {
            valueFirst = input.readCharAndSkip(SPACES);
            if (first && valueFirst == ']') {
                return list;
            }
            first = false;
            Object value = this.parseValue(input, valueFirst, parsingMode, parentConfig);
            list.add(value);
            next = input.readCharAndSkip(SPACES);
            if (next != ']') continue;
            return list;
        } while (next == ',');
        throw new ParsingException("Invalid value separator: " + valueFirst);
    }

    private Object parseValue(CharacterInput input, char firstChar, ParsingMode parsingMode, Config parentConfig) {
        switch (firstChar) {
            case '\"': {
                return this.parseString(input);
            }
            case '{': {
                return this.parseObject(input, parentConfig.createSubConfig(), parsingMode);
            }
            case '[': {
                return this.parseArray(input, new ArrayList(), parsingMode, parentConfig);
            }
            case 't': {
                return this.parseTrue(input);
            }
            case 'f': {
                return this.parseFalse(input);
            }
            case 'n': {
                return this.parseNull(input);
            }
        }
        input.pushBack(firstChar);
        return this.parseNumber(input);
    }

    private Number parseNumber(CharacterInput input) {
        int small;
        CharsWrapper chars = input.readCharsUntil(NUMBER_END);
        if (chars.contains('.') || chars.contains('e') || chars.contains('E')) {
            return Utils.parseDouble((CharsWrapper)chars);
        }
        long l = Utils.parseLong((CharsWrapper)chars, (int)10);
        if (l == (long)(small = (int)l)) {
            return small;
        }
        return l;
    }

    private boolean parseTrue(CharacterInput input) {
        CharsWrapper chars = input.readChars(3);
        if (!chars.contentEquals(TRUE_LAST)) {
            throw new ParsingException("Invalid value: t" + chars + " - expected boolean true");
        }
        return true;
    }

    private boolean parseFalse(CharacterInput input) {
        CharsWrapper chars = input.readChars(4);
        if (!chars.contentEquals(FALSE_LAST)) {
            throw new ParsingException("Invalid value: f" + chars + " - expected boolean false");
        }
        return false;
    }

    private Object parseNull(CharacterInput input) {
        CharsWrapper chars = input.readChars(3);
        if (!chars.contentEquals(NULL_LAST)) {
            throw new ParsingException("Invaid value: n" + chars + " - expected null");
        }
        return null;
    }

    private String parseString(CharacterInput input) {
        char c;
        StringBuilder builder = new StringBuilder();
        boolean escape = false;
        while ((c = input.readChar()) != '\"' || escape) {
            if (escape) {
                builder.append(this.escape(c, input));
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private char escape(char c, CharacterInput input) {
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                return c;
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'u': {
                CharsWrapper chars = input.readChars(4);
                return (char)Utils.parseInt((CharsWrapper)chars, (int)16);
            }
        }
        throw new ParsingException("Invalid escapement: \\" + c);
    }

    private /* synthetic */ void lambda$parse$0(ParsingMode parsingMode, CharacterInput input, Config view) {
        parsingMode.prepareParsing(view);
        this.parseObject(input, view, parsingMode);
    }
}

