/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import eightbitlab.com.blurview.BlockingBlurController;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.R;

public class BlurView
extends FrameLayout {
    private static final String TAG = BlurView.class.getSimpleName();
    @ColorInt
    private static final int TRANSPARENT = 0;
    BlurController blurController = this.createStubController();
    @ColorInt
    private int overlayColor;

    public BlurView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public BlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public BlurView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BlurView, defStyleAttr, 0);
        this.overlayColor = a.getColor(R.styleable.BlurView_blurOverlayColor, 0);
        a.recycle();
        this.setWillNotDraw(false);
    }

    public void draw(Canvas canvas) {
        if (canvas.isHardwareAccelerated()) {
            this.blurController.drawBlurredContent(canvas);
            if (this.overlayColor != 0) {
                canvas.drawColor(this.overlayColor);
            }
            super.draw(canvas);
        } else if (!this.isHardwareAccelerated()) {
            super.draw(canvas);
        }
    }

    public BlurView setBlurAutoUpdate(final boolean enabled) {
        this.post(new Runnable(){

            @Override
            public void run() {
                BlurView.this.blurController.setBlurAutoUpdate(enabled);
            }
        });
        return this;
    }

    public BlurView setBlurEnabled(final boolean enabled) {
        this.post(new Runnable(){

            @Override
            public void run() {
                BlurView.this.blurController.setBlurEnabled(enabled);
            }
        });
        return this;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.blurController.updateBlurViewSize();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.blurController.onDrawEnd(canvas);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.blurController.setBlurAutoUpdate(false);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isHardwareAccelerated()) {
            Log.e((String)TAG, (String)"BlurView can't be used in not hardware-accelerated window!");
        } else {
            this.blurController.setBlurAutoUpdate(true);
        }
    }

    private void setBlurController(@NonNull BlurController blurController) {
        this.blurController.destroy();
        this.blurController = blurController;
    }

    public BlurView setOverlayColor(@ColorInt int overlayColor) {
        if (overlayColor != this.overlayColor) {
            this.overlayColor = overlayColor;
            this.invalidate();
        }
        return this;
    }

    public BlurView setHasFixedTransformationMatrix(boolean hasFixedTransformationMatrix) {
        this.blurController.setHasFixedTransformationMatrix(hasFixedTransformationMatrix);
        return this;
    }

    public BlurView setupWith(@NonNull ViewGroup rootView) {
        BlockingBlurController blurController = new BlockingBlurController((View)this, rootView);
        this.setBlurController(blurController);
        if (!this.isHardwareAccelerated()) {
            blurController.setBlurAutoUpdate(false);
        }
        return this;
    }

    public BlurView setBlurRadius(float radius) {
        this.blurController.setBlurRadius(radius);
        return this;
    }

    public BlurView setBlurAlgorithm(BlurAlgorithm algorithm) {
        this.blurController.setBlurAlgorithm(algorithm);
        return this;
    }

    public BlurView setFrameClearDrawable(@Nullable Drawable frameClearDrawable) {
        this.blurController.setFrameClearDrawable(frameClearDrawable);
        return this;
    }

    private BlurController createStubController() {
        return new BlurController(){

            @Override
            public void drawBlurredContent(Canvas canvas) {
            }

            @Override
            public void updateBlurViewSize() {
            }

            @Override
            public void onDrawEnd(Canvas canvas) {
            }

            @Override
            public void setBlurRadius(float radius) {
            }

            @Override
            public void setBlurAlgorithm(BlurAlgorithm algorithm) {
            }

            @Override
            public void setFrameClearDrawable(@Nullable Drawable windowBackground) {
            }

            @Override
            public void destroy() {
            }

            @Override
            public void setBlurEnabled(boolean enabled) {
            }

            @Override
            public void setBlurAutoUpdate(boolean enabled) {
            }

            @Override
            public void setHasFixedTransformationMatrix(boolean hasFixedTransformationMatrix) {
            }
        };
    }
}

