/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.NoOpBlurAlgorithm;

class BlockingBlurController
implements BlurController {
    private static final int ROUNDING_VALUE = 16;
    private final float scaleFactor = 8.0f;
    private float blurRadius = 16.0f;
    private float roundingWidthScaleFactor = 1.0f;
    private float roundingHeightScaleFactor = 1.0f;
    private BlurAlgorithm blurAlgorithm;
    private Canvas internalCanvas;
    private Bitmap internalBitmap;
    final View blurView;
    private final ViewGroup rootView;
    private final Rect relativeViewBounds = new Rect();
    private final int[] locationInWindow = new int[2];
    private final ViewTreeObserver.OnPreDrawListener drawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            if (!BlockingBlurController.this.isMeDrawingNow) {
                BlockingBlurController.this.updateBlur();
            }
            return true;
        }
    };
    boolean isMeDrawingNow;
    private boolean isBlurEnabled = true;
    private final Runnable onDrawEndTask = new Runnable(){

        @Override
        public void run() {
            BlockingBlurController.this.isMeDrawingNow = false;
        }
    };
    @Nullable
    private Drawable frameClearDrawable;
    private boolean shouldTryToOffsetCoords = true;
    private boolean hasFixedTransformationMatrix;
    private final Paint paint = new Paint();

    BlockingBlurController(@NonNull View blurView, @NonNull ViewGroup rootView) {
        this.rootView = rootView;
        this.blurView = blurView;
        this.blurAlgorithm = new NoOpBlurAlgorithm();
        this.paint.setFilterBitmap(true);
        int measuredWidth = blurView.getMeasuredWidth();
        int measuredHeight = blurView.getMeasuredHeight();
        if (this.isZeroSized(measuredWidth, measuredHeight)) {
            this.deferBitmapCreation();
            return;
        }
        this.init(measuredWidth, measuredHeight);
    }

    private int downScaleSize(float value) {
        return (int)Math.ceil(value / 8.0f);
    }

    private int roundSize(int value) {
        if (value % 16 == 0) {
            return value;
        }
        return value - value % 16 + 16;
    }

    void init(int measuredWidth, int measuredHeight) {
        if (this.isZeroSized(measuredWidth, measuredHeight)) {
            this.isBlurEnabled = false;
            this.blurView.setWillNotDraw(true);
            this.setBlurAutoUpdate(false);
            return;
        }
        this.isBlurEnabled = true;
        this.blurView.setWillNotDraw(false);
        this.allocateBitmap(measuredWidth, measuredHeight);
        this.internalCanvas = new Canvas(this.internalBitmap);
        this.setBlurAutoUpdate(true);
        if (this.hasFixedTransformationMatrix) {
            this.setupInternalCanvasMatrix();
        }
    }

    private boolean isZeroSized(int measuredWidth, int measuredHeight) {
        return this.downScaleSize(measuredHeight) == 0 || this.downScaleSize(measuredWidth) == 0;
    }

    void updateBlur() {
        this.isMeDrawingNow = true;
        this.blurView.invalidate();
    }

    private void deferBitmapCreation() {
        this.blurView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    BlockingBlurController.this.blurView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    this.legacyRemoveOnGlobalLayoutListener();
                }
                int measuredWidth = BlockingBlurController.this.blurView.getMeasuredWidth();
                int measuredHeight = BlockingBlurController.this.blurView.getMeasuredHeight();
                BlockingBlurController.this.init(measuredWidth, measuredHeight);
            }

            void legacyRemoveOnGlobalLayoutListener() {
                BlockingBlurController.this.blurView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void allocateBitmap(int measuredWidth, int measuredHeight) {
        int nonRoundedScaledWidth = this.downScaleSize(measuredWidth);
        int nonRoundedScaledHeight = this.downScaleSize(measuredHeight);
        int scaledWidth = this.roundSize(nonRoundedScaledWidth);
        int scaledHeight = this.roundSize(nonRoundedScaledHeight);
        this.roundingHeightScaleFactor = (float)nonRoundedScaledHeight / (float)scaledHeight;
        this.roundingWidthScaleFactor = (float)nonRoundedScaledWidth / (float)scaledWidth;
        this.internalBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)this.blurAlgorithm.getSupportedBitmapConfig());
    }

    private void setupInternalCanvasMatrix() {
        this.blurView.getDrawingRect(this.relativeViewBounds);
        if (this.shouldTryToOffsetCoords) {
            try {
                this.rootView.offsetDescendantRectToMyCoords(this.blurView, this.relativeViewBounds);
            }
            catch (IllegalArgumentException e) {
                this.shouldTryToOffsetCoords = false;
            }
        } else {
            this.blurView.getLocationInWindow(this.locationInWindow);
            this.relativeViewBounds.offset(this.locationInWindow[0], this.locationInWindow[1]);
        }
        float scaleFactorX = 8.0f * this.roundingWidthScaleFactor;
        float scaleFactorY = 8.0f * this.roundingHeightScaleFactor;
        float scaledLeftPosition = (float)(-this.relativeViewBounds.left) / scaleFactorX;
        float scaledTopPosition = (float)(-this.relativeViewBounds.top) / scaleFactorY;
        float scaledTranslationX = this.blurView.getTranslationX() / scaleFactorX;
        float scaledTranslationY = this.blurView.getTranslationY() / scaleFactorY;
        this.internalCanvas.translate(scaledLeftPosition - scaledTranslationX, scaledTopPosition - scaledTranslationY);
        this.internalCanvas.scale(1.0f / scaleFactorX, 1.0f / scaleFactorY);
    }

    @Override
    public void drawBlurredContent(Canvas canvas) {
        this.isMeDrawingNow = true;
        if (this.isBlurEnabled) {
            if (this.frameClearDrawable == null) {
                this.internalBitmap.eraseColor(0);
            } else {
                this.frameClearDrawable.draw(this.internalCanvas);
            }
            if (this.hasFixedTransformationMatrix) {
                this.rootView.draw(this.internalCanvas);
            } else {
                this.internalCanvas.save();
                this.setupInternalCanvasMatrix();
                this.rootView.draw(this.internalCanvas);
                this.internalCanvas.restore();
            }
            this.blurAndSave();
            this.draw(canvas);
        }
    }

    private void draw(Canvas canvas) {
        canvas.save();
        canvas.scale(8.0f * this.roundingWidthScaleFactor, 8.0f * this.roundingHeightScaleFactor);
        canvas.drawBitmap(this.internalBitmap, 0.0f, 0.0f, this.paint);
        canvas.restore();
    }

    @Override
    public void onDrawEnd(Canvas canvas) {
        this.blurView.post(this.onDrawEndTask);
    }

    private void blurAndSave() {
        this.internalBitmap = this.blurAlgorithm.blur(this.internalBitmap, this.blurRadius);
    }

    @Override
    public void updateBlurViewSize() {
        int measuredWidth = this.blurView.getMeasuredWidth();
        int measuredHeight = this.blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    @Override
    public void destroy() {
        this.setBlurAutoUpdate(false);
        this.blurAlgorithm.destroy();
        if (this.internalBitmap != null) {
            this.internalBitmap.recycle();
        }
    }

    @Override
    public void setBlurRadius(float radius) {
        this.blurRadius = radius;
    }

    @Override
    public void setBlurAlgorithm(BlurAlgorithm algorithm) {
        this.blurAlgorithm = algorithm;
    }

    @Override
    public void setFrameClearDrawable(@Nullable Drawable frameClearDrawable) {
        this.frameClearDrawable = frameClearDrawable;
    }

    @Override
    public void setBlurEnabled(boolean enabled) {
        this.isBlurEnabled = enabled;
        this.setBlurAutoUpdate(enabled);
        this.blurView.invalidate();
    }

    @Override
    public void setBlurAutoUpdate(boolean enabled) {
        this.blurView.getViewTreeObserver().removeOnPreDrawListener(this.drawListener);
        if (enabled) {
            this.blurView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
        }
    }

    @Override
    public void setHasFixedTransformationMatrix(boolean hasFixedTransformationMatrix) {
        this.hasFixedTransformationMatrix = hasFixedTransformationMatrix;
    }
}

