/*
 * Decompiled with CFR 0.152.
 */
package com.efraespada.jsondiff;

import android.util.Log;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONDiff {
    private static String TAG = JSONDiff.class.getSimpleName();
    private static final String SEPARATOR = ".";
    private static final String TAG_SET = "$set";
    private static final String TAG_UNSET = "$unset";
    private static final String TAG_RENAME = "$rename";
    private static boolean DEBUG = false;

    private JSONDiff() {
    }

    public static Map<String, JSONObject> diff(JSONObject a, JSONObject b) {
        Map<String, Object> mapA = JSONDiff.getMap(a);
        Map<String, Object> mapB = JSONDiff.getMap(b);
        HashMap<String, JSONObject> holder = new HashMap<String, JSONObject>();
        holder.put(TAG_SET, new JSONObject());
        holder.put(TAG_UNSET, new JSONObject());
        holder.put(TAG_RENAME, new JSONObject());
        JSONDiff.hashMapper(holder, "", mapA, mapB);
        if (JSONDiff.emptySet((JSONObject)holder.get(TAG_SET))) {
            holder.remove(TAG_SET);
        }
        if (JSONDiff.emptySet((JSONObject)holder.get(TAG_UNSET))) {
            holder.remove(TAG_UNSET);
        }
        if (JSONDiff.emptySet((JSONObject)holder.get(TAG_RENAME))) {
            holder.remove(TAG_RENAME);
        }
        return holder;
    }

    private static boolean emptySet(JSONObject object) {
        return object.toString().length() <= 2;
    }

    private static Map<String, Object> getMap(JSONObject a) {
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            map = (Map)mapper.readValue(a.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return map;
        }
    }

    public static void setDebug(boolean DEBUG) {
        JSONDiff.DEBUG = DEBUG;
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, G> void hashMapper(Map<String, JSONObject> holder, String path, Map<T, K> mapA, Map<T, K> mapB) {
        void var6_11;
        void var6_9;
        ArrayList<T> keysA = new ArrayList<T>();
        for (Map.Entry<T, K> entry : mapA.entrySet()) {
            keysA.add(entry.getKey());
        }
        ArrayList<T> keysB = new ArrayList<T>();
        for (Map.Entry<T, K> entry : mapB.entrySet()) {
            keysB.add(entry.getKey());
        }
        boolean bl = false;
        while (var6_9 < keysA.size()) {
            Object e = keysA.get((int)var6_9);
            K valueA = mapA.get(keysA.get((int)var6_9));
            if (mapB.containsKey(e)) {
                Object keyB = e;
                K valueB = mapB.get(keyB);
                if (valueA instanceof String && valueB instanceof String) {
                    if (!valueA.equals(valueB)) {
                        try {
                            holder.get(TAG_SET).put(path + (path.length() == 0 ? "" : SEPARATOR) + e, valueB);
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                        }
                    }
                } else if (valueA instanceof Long && valueB instanceof Long || valueA instanceof Integer && valueB instanceof Integer) {
                    if (valueA != valueB) {
                        try {
                            holder.get(TAG_SET).put(path + (path.length() == 0 ? "" : SEPARATOR) + e, valueB);
                        }
                        catch (JSONException e3) {
                            e3.printStackTrace();
                        }
                    }
                } else if (valueA instanceof Map && valueB instanceof Map) {
                    JSONDiff.hashMapper(holder, path + (path.length() == 0 ? "" : SEPARATOR) + e, (Map)valueA, (Map)valueB);
                } else if (valueA instanceof List && valueB instanceof List) {
                    try {
                        if (DEBUG) {
                            Log.e((String)TAG, (String)String.valueOf(valueB));
                        }
                        JSONArray arraySet = new JSONArray();
                        for (Object elemB : (List)valueB) {
                            if (((List)valueA).contains(elemB)) continue;
                            arraySet.put(elemB);
                        }
                        holder.get(TAG_SET).put(path + (path.length() == 0 ? "" : SEPARATOR) + keyB, (Object)arraySet);
                        JSONArray arrayUnset = new JSONArray();
                        for (Object elemA : (List)valueA) {
                            if (((List)valueB).contains(elemA)) continue;
                            arrayUnset.put(elemA);
                        }
                        holder.get(TAG_UNSET).put(path + (path.length() == 0 ? "" : SEPARATOR) + keyB, (Object)arrayUnset);
                    }
                    catch (JSONException e4) {
                        e4.printStackTrace();
                    }
                } else if (DEBUG) {
                    Log.e((String)TAG, (String)("not mapped value: " + String.valueOf(valueA)));
                }
            } else {
                try {
                    holder.get(TAG_UNSET).put(path + (path.length() == 0 ? "" : SEPARATOR) + e, valueA);
                }
                catch (JSONException e5) {
                    e5.printStackTrace();
                }
            }
            ++var6_9;
        }
        boolean bl2 = false;
        while (var6_11 < keysB.size()) {
            Object e = keysB.get((int)var6_11);
            K valueB = mapB.get(keysB.get((int)var6_11));
            if (!mapA.containsKey(e)) {
                if (valueB instanceof String) {
                    try {
                        holder.get(TAG_SET).put(path + (path.length() == 0 ? "" : SEPARATOR) + e, valueB);
                    }
                    catch (JSONException e6) {
                        e6.printStackTrace();
                    }
                } else if (valueB instanceof Long || valueB instanceof Integer) {
                    try {
                        holder.get(TAG_SET).put(path + (path.length() == 0 ? "" : SEPARATOR) + e, valueB);
                    }
                    catch (JSONException e7) {
                        e7.printStackTrace();
                    }
                } else if (valueB instanceof Map) {
                    try {
                        holder.get(TAG_SET).put(path + (path.length() == 0 ? "" : SEPARATOR) + e, (Object)new JSONObject("{}"));
                        JSONDiff.hashMapper(holder, path + (path.length() == 0 ? "" : SEPARATOR) + e, new HashMap(), (Map)valueB);
                    }
                    catch (JSONException e8) {
                        e8.printStackTrace();
                    }
                } else if (valueB instanceof List) {
                    try {
                        if (DEBUG) {
                            Log.e((String)TAG, (String)String.valueOf(valueB));
                        }
                        JSONArray array = new JSONArray();
                        for (Object elem : (List)valueB) {
                            array.put(elem);
                        }
                        holder.get(TAG_SET).put(path + (path.length() == 0 ? "" : SEPARATOR) + e, (Object)array);
                    }
                    catch (JSONException e9) {
                        e9.printStackTrace();
                    }
                } else if (DEBUG) {
                    Log.e((String)TAG, (String)("not mapped value: " + String.valueOf(valueB)));
                }
            }
            ++var6_11;
        }
    }
}

