/*
 * Decompiled with CFR 0.152.
 */
package com.efortunetech;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.UUID;

public class asyncNetwork
extends AsyncTask<String, Void, String> {
    private String json = "";
    private Context context;
    private String url;
    private String data = "";
    private int responseCode = -1;
    private Map<String, String> fields;
    private Map<String, File> files;
    private OnAsyncTaskCompleted listener;
    private OnAsyncNetworkCompleted newListener;

    public asyncNetwork(OnAsyncTaskCompleted callback, Context c, String u) {
        this.context = c;
        this.url = u;
        this.listener = callback;
    }

    public asyncNetwork(OnAsyncTaskCompleted callback, Context c, String u, String d) {
        this.context = c;
        this.url = u;
        this.listener = callback;
        this.data = d;
    }

    public asyncNetwork(Context c, String u) {
        this.context = c;
        this.url = u;
    }

    public asyncNetwork(OnAsyncNetworkCompleted callback, Context c, String u, Map<String, String> params) {
        this.init(callback, c, u, params, null);
    }

    public asyncNetwork(OnAsyncNetworkCompleted callback, Context c, String u, Map<String, String> params, Map<String, File> files) {
        this.init(callback, c, u, params, files);
    }

    private void init(OnAsyncNetworkCompleted callback, Context c, String u, Map<String, String> params, Map<String, File> files) {
        this.context = c;
        this.url = u;
        this.fields = params;
        this.files = files;
        this.newListener = callback;
    }

    protected String doInBackground(String ... params) {
        InputStream myStream = TextUtils.isEmpty((CharSequence)this.data) && this.listener != null ? this.getStream(this.url) : (!TextUtils.isEmpty((CharSequence)this.data) && this.listener != null ? this.getStream(this.url, this.data) : this.getStream(this.url, this.fields, this.files));
        if (myStream != null) {
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(myStream));
                String newLine = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append(newLine);
                }
                this.json = sb.toString();
            }
            catch (Exception e) {
                Log.e((String)"Buffer Error", (String)("Error converting result " + e.toString()));
            }
        } else {
            Log.e((String)"ORM", (String)"ASyncNetwork doInBackground Exception ");
        }
        return this.json;
    }

    private InputStream getStream(String u) {
        try {
            URL url = new URL(u);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(15000);
            urlConnection.setRequestProperty("connection", "close");
            return urlConnection.getInputStream();
        }
        catch (Exception ex) {
            Log.e((String)"ORM", (String)ex.toString());
            return null;
        }
    }

    private InputStream getStream(String u, String data) {
        try {
            URL url = new URL(u);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream());
            writer.write(data);
            writer.flush();
            urlConnection.setConnectTimeout(15000);
            return urlConnection.getInputStream();
        }
        catch (Exception ex) {
            Log.e((String)"ORM", (String)ex.toString());
            return null;
        }
    }

    private InputStream getStream(String u, Map<String, String> params, Map<String, File> files) {
        String BOUNDARY = UUID.randomUUID().toString();
        HttpURLConnection conn = null;
        String PREFIX = "--";
        String LINE_END = "\r\n";
        Log.i((String)"ORM", (String)"getStream: map");
        Log.i((String)"ORM", (String)("getStream: params" + params));
        try {
            URL url = new URL(u);
            conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Accept", "*/*");
            conn.setRequestProperty("Connection", "Keep-alive");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + BOUNDARY);
            if (params != null && !params.isEmpty() || files != null && !files.isEmpty()) {
                conn.setDoOutput(true);
                DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
                if (params != null && !params.isEmpty()) {
                    Log.i((String)"ORM", (String)"getStream: params write");
                    StringBuffer sb = new StringBuffer();
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        sb.append(PREFIX);
                        sb.append(BOUNDARY);
                        sb.append(LINE_END);
                        sb.append("Content-Disposition:form-data;name=\"" + entry.getKey() + "\"" + LINE_END);
                        sb.append("Content-Transfer-Encoding:8bit" + LINE_END);
                        sb.append(LINE_END);
                        sb.append(entry.getValue());
                        sb.append(LINE_END);
                    }
                    outputStream.write(sb.toString().getBytes());
                }
                if (files != null && !files.isEmpty()) {
                    Log.i((String)"ORM", (String)"getStream: file write");
                    for (Map.Entry entry : files.entrySet()) {
                        StringBuffer sb1 = new StringBuffer();
                        sb1.append(PREFIX);
                        sb1.append(BOUNDARY);
                        sb1.append(LINE_END);
                        sb1.append("Content-Disposition:form-data;name=\"" + (String)entry.getKey() + "\";filename=\"" + ((File)entry.getValue()).getName() + "\"" + LINE_END);
                        sb1.append("Content-Type:application/octet-stream;charset=UTF-8" + LINE_END);
                        sb1.append(LINE_END);
                        outputStream.write(sb1.toString().getBytes());
                        FileInputStream is = new FileInputStream((File)entry.getValue());
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        while ((len = ((InputStream)is).read(buffer)) != -1) {
                            outputStream.write(buffer, 0, len);
                        }
                        ((InputStream)is).close();
                        outputStream.write(LINE_END.getBytes());
                    }
                }
                if (params != null && !params.isEmpty() || files != null && !files.isEmpty()) {
                    Log.i((String)"ORM", (String)"getStream: end write");
                    byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINE_END).getBytes();
                    outputStream.write(end_data);
                }
                outputStream.flush();
            }
            this.responseCode = conn.getResponseCode();
            return this.responseCode == 200 ? conn.getInputStream() : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void onPostExecute(String result) {
        if (this.listener != null) {
            this.listener.onAsyncTaskCompleted(result);
        }
        if (this.newListener != null) {
            this.newListener.onAsyncTaskCompleted(result, this.responseCode);
        }
    }

    public static interface OnAsyncNetworkCompleted {
        public void onAsyncTaskCompleted(String var1, int var2);
    }

    public static interface OnAsyncTaskCompleted {
        public void onAsyncTaskCompleted(String var1);
    }
}

