/*
 * Decompiled with CFR 0.152.
 */
package com.efortunetech;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.efortunetech.R;
import com.efortunetech.asyncNetwork;
import java.io.File;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONResponse {
    private Context context;
    private String url;
    private String data;
    private onComplete listener;
    private Map<String, String> params;
    private Map<String, File> files;
    private JSONResponseComplete newListener;

    public JSONResponse(Context c, String u, onComplete cb) {
        this.context = c;
        this.url = u;
        this.listener = cb;
        this.getJsonAsync();
    }

    public JSONResponse(Context c, String u, String d, onComplete cb) {
        this.context = c;
        this.url = u;
        this.listener = cb;
        this.data = d;
        this.getJsonAsync();
    }

    public JSONResponse(Context c, String u) {
        this.context = c;
        this.url = u;
    }

    public JSONResponse(Context c, String u, JSONResponseComplete cb) {
        this.init(c, u, null, null, cb);
    }

    public JSONResponse(Context c, String u, Map<String, String> params, JSONResponseComplete cb) {
        this.init(c, u, params, null, cb);
    }

    public JSONResponse(Context c, String u, Map<String, String> params, Map<String, File> files, JSONResponseComplete cb) {
        this.init(c, u, params, files, cb);
    }

    private void init(Context c, String u, Map<String, String> params, Map<String, File> files, JSONResponseComplete cb) {
        this.context = c;
        this.url = u;
        this.newListener = cb;
        this.params = params;
        this.files = files;
        this.getJsonAsyncByMap();
    }

    public void getJsonAsync() {
        if (!TextUtils.isEmpty((CharSequence)this.data)) {
            asyncNetwork asyncNetwork2 = (asyncNetwork)new asyncNetwork(new asyncNetwork.OnAsyncTaskCompleted(){

                @Override
                public void onAsyncTaskCompleted(String response) {
                    JSONObject jsonObj;
                    block2: {
                        jsonObj = new JSONObject();
                        try {
                            jsonObj = new JSONObject(response);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (JSONResponse.this.context == null) break block2;
                            Toast.makeText((Context)JSONResponse.this.context, (int)R.string.connection_error, (int)1).show();
                        }
                    }
                    JSONResponse.this.listener.onComplete(jsonObj);
                }
            }, this.context, this.url, this.data).execute(new String[0]);
        } else {
            asyncNetwork asyncNetwork3 = (asyncNetwork)new asyncNetwork(new asyncNetwork.OnAsyncTaskCompleted(){

                @Override
                public void onAsyncTaskCompleted(String response) {
                    JSONObject jsonObj;
                    block2: {
                        jsonObj = new JSONObject();
                        try {
                            jsonObj = new JSONObject(response);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (JSONResponse.this.context == null) break block2;
                            Toast.makeText((Context)JSONResponse.this.context, (int)R.string.connection_error, (int)1).show();
                        }
                    }
                    JSONResponse.this.listener.onComplete(jsonObj);
                }
            }, this.context, this.url).execute(new String[0]);
        }
    }

    private void getJsonAsyncByMap() {
        new asyncNetwork(new asyncNetwork.OnAsyncNetworkCompleted(){

            @Override
            public void onAsyncTaskCompleted(String response, int responseCode) {
                Log.i((String)"ORM", (String)("onAsyncTaskCompleted: " + response));
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject = new JSONObject(response);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Log.i((String)"ORM", (String)("onAsyncTaskCompleted: rc = " + responseCode));
                JSONResponse.this.newListener.onComplete(jsonObject, responseCode != 200);
            }
        }, this.context, this.url, this.params, this.files).execute(new String[0]);
    }

    public JSONObject getJsonObj(int i, String responseText) {
        JSONObject c = null;
        if (responseText != null) {
            try {
                JSONObject jsonObj = new JSONObject(responseText);
                JSONArray unitPt = jsonObj.getJSONArray("data");
                c = unitPt.getJSONObject(i);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return c;
    }

    public static interface JSONResponseComplete {
        public void onComplete(JSONObject var1, boolean var2);
    }

    public static interface onComplete {
        public void onComplete(JSONObject var1);
    }
}

