/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.request;

import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.Unpooled;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.DefaultFullHttpRequest;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.DefaultHttpRequest;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpMethod;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpVersion;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import gigahorse.shaded.ahc.io.netty.util.AsciiString;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.Realm;
import gigahorse.shaded.ahc.org.asynchttpclient.Request;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.NettyRequest;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBodyBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyByteArrayBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyByteBufferBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyCompositeByteArrayBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyDirectBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyFileBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyInputStreamBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyMultipartBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyReactiveStreamsBody;
import gigahorse.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator.FileBodyGenerator;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import gigahorse.shaded.ahc.org.asynchttpclient.uri.Uri;
import gigahorse.shaded.ahc.org.asynchttpclient.util.AuthenticatorUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.StringUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.ws.WebSocketUtils;
import java.nio.charset.Charset;
import java.util.Collection;

public final class NettyRequestFactory {
    private static final Integer ZERO_CONTENT_LENGTH = 0;
    private final AsyncHttpClientConfig config;
    private final ClientCookieEncoder cookieEncoder;

    NettyRequestFactory(AsyncHttpClientConfig config) {
        this.config = config;
        this.cookieEncoder = config.isUseLaxCookieEncoder() ? ClientCookieEncoder.LAX : ClientCookieEncoder.STRICT;
    }

    private NettyBody body(Request request) {
        NettyBody nettyBody = null;
        Charset bodyCharset = request.getCharset();
        if (request.getByteData() != null) {
            nettyBody = new NettyByteArrayBody(request.getByteData());
        } else if (request.getCompositeByteData() != null) {
            nettyBody = new NettyCompositeByteArrayBody(request.getCompositeByteData());
        } else if (request.getStringData() != null) {
            nettyBody = new NettyByteBufferBody(StringUtils.charSequence2ByteBuffer(request.getStringData(), bodyCharset));
        } else if (request.getByteBufferData() != null) {
            nettyBody = new NettyByteBufferBody(request.getByteBufferData());
        } else if (request.getStreamData() != null) {
            nettyBody = new NettyInputStreamBody(request.getStreamData());
        } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
            AsciiString contentTypeOverride = request.getHeaders().contains(HttpHeaderNames.CONTENT_TYPE) ? null : HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED;
            nettyBody = new NettyByteBufferBody(HttpUtils.urlEncodeFormParams(request.getFormParams(), bodyCharset), contentTypeOverride);
        } else if (MiscUtils.isNonEmpty(request.getBodyParts())) {
            nettyBody = new NettyMultipartBody(request.getBodyParts(), request.getHeaders(), this.config);
        } else if (request.getFile() != null) {
            nettyBody = new NettyFileBody(request.getFile(), this.config);
        } else if (request.getBodyGenerator() instanceof FileBodyGenerator) {
            FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request.getBodyGenerator();
            nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.config);
        } else if (request.getBodyGenerator() instanceof InputStreamBodyGenerator) {
            InputStreamBodyGenerator inStreamGenerator = (InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request.getBodyGenerator());
            nettyBody = new NettyInputStreamBody(inStreamGenerator.getInputStream(), inStreamGenerator.getContentLength());
        } else if (request.getBodyGenerator() instanceof ReactiveStreamsBodyGenerator) {
            ReactiveStreamsBodyGenerator reactiveStreamsBodyGenerator = (ReactiveStreamsBodyGenerator)request.getBodyGenerator();
            nettyBody = new NettyReactiveStreamsBody(reactiveStreamsBodyGenerator.getPublisher(), reactiveStreamsBodyGenerator.getContentLength());
        } else if (request.getBodyGenerator() != null) {
            nettyBody = new NettyBodyBody(request.getBodyGenerator().createBody(), this.config);
        }
        return nettyBody;
    }

    public void addAuthorizationHeader(HttpHeaders headers, String authorizationHeader) {
        if (authorizationHeader != null) {
            headers.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)authorizationHeader);
        }
    }

    public void setProxyAuthorizationHeader(HttpHeaders headers, String proxyAuthorizationHeader) {
        if (proxyAuthorizationHeader != null) {
            headers.set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)proxyAuthorizationHeader);
        }
    }

    public NettyRequest newNettyRequest(Request request, boolean performConnectRequest, ProxyServer proxyServer, Realm realm, Realm proxyRealm) {
        CharSequence connectionHeaderValue;
        NettyRequest nettyRequest;
        DefaultHttpRequest httpRequest;
        NettyBody body;
        Uri uri = request.getUri();
        HttpMethod method = performConnectRequest ? HttpMethod.CONNECT : HttpMethod.valueOf(request.getMethod());
        boolean connect = method == HttpMethod.CONNECT;
        HttpVersion httpVersion = HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, connect);
        NettyBody nettyBody = body = connect ? null : this.body(request);
        if (body == null) {
            httpRequest = new DefaultFullHttpRequest(httpVersion, method, requestUri, Unpooled.EMPTY_BUFFER);
            nettyRequest = new NettyRequest(httpRequest, null);
        } else if (body instanceof NettyDirectBody) {
            ByteBuf buf = ((NettyDirectBody)NettyDirectBody.class.cast(body)).byteBuf();
            DefaultFullHttpRequest httpRequest2 = new DefaultFullHttpRequest(httpVersion, method, requestUri, buf);
            nettyRequest = new NettyRequest(httpRequest2, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest(httpRequest, body);
        }
        HttpHeaders headers = nettyRequest.getHttpRequest().headers();
        if (connect) {
            headers.set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, request.getHeaders().getAll(HttpHeaderNames.PROXY_AUTHORIZATION));
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, request.getHeaders().getAll(HttpHeaderNames.USER_AGENT));
        } else {
            String userDefinedAcceptEncoding;
            headers.set(request.getHeaders());
            if (MiscUtils.isNonEmpty(request.getCookies())) {
                headers.set((CharSequence)HttpHeaderNames.COOKIE, (Object)this.cookieEncoder.encode((Collection<? extends Cookie>)request.getCookies()));
            }
            if ((userDefinedAcceptEncoding = headers.get(HttpHeaderNames.ACCEPT_ENCODING)) != null) {
                headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpUtils.filterOutBrotliFromAcceptEncoding(userDefinedAcceptEncoding));
            } else if (this.config.isCompressionEnforced()) {
                headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpUtils.GZIP_DEFLATE);
            }
        }
        if (!headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
            if (body != null) {
                if (body.getContentLength() < 0L) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                } else {
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.getContentLength());
                }
            } else if (method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)ZERO_CONTENT_LENGTH);
            }
        }
        if (body != null && body.getContentTypeOverride() != null) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)body.getContentTypeOverride());
        }
        if (!connect && uri.isWebSocket()) {
            headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)WebSocketUtils.getWebSocketKey()).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
            if (!headers.contains(HttpHeaderNames.ORIGIN)) {
                headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)HttpUtils.originHeader(uri));
            }
        } else if (!headers.contains(HttpHeaderNames.CONNECTION) && (connectionHeaderValue = this.connectionHeader(this.config.isKeepAlive(), httpVersion)) != null) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)connectionHeaderValue);
        }
        if (!headers.contains(HttpHeaderNames.HOST)) {
            String virtualHost = request.getVirtualHost();
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(virtualHost != null ? virtualHost : HttpUtils.hostHeader(uri)));
        }
        this.addAuthorizationHeader(headers, AuthenticatorUtils.perRequestAuthorizationHeader(request, realm));
        if (!uri.isSecured() || connect) {
            this.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perRequestProxyAuthorizationHeader(request, proxyRealm));
        }
        if (!headers.contains(HttpHeaderNames.ACCEPT)) {
            headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)HttpUtils.ACCEPT_ALL_HEADER_VALUE);
        }
        if (!headers.contains(HttpHeaderNames.USER_AGENT) && this.config.getUserAgent() != null) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.config.getUserAgent());
        }
        return nettyRequest;
    }

    private String requestUri(Uri uri, ProxyServer proxyServer, boolean connect) {
        if (connect) {
            return uri.getAuthority();
        }
        if (proxyServer != null && !uri.isSecured() && proxyServer.getProxyType().isHttp()) {
            return uri.toUrl();
        }
        return uri.toRelativeUrl();
    }

    private CharSequence connectionHeader(boolean keepAlive, HttpVersion httpVersion) {
        if (httpVersion.isKeepAliveDefault()) {
            return keepAlive ? null : HttpHeaderValues.CLOSE;
        }
        return keepAlive ? HttpHeaderValues.KEEP_ALIVE : null;
    }
}

