/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.util;

import gigahorse.shaded.ahc.org.asynchttpclient.Realm;
import gigahorse.shaded.ahc.org.asynchttpclient.Request;
import gigahorse.shaded.ahc.org.asynchttpclient.ntlm.NtlmEngine;
import gigahorse.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import gigahorse.shaded.ahc.org.asynchttpclient.spnego.SpnegoEngine;
import gigahorse.shaded.ahc.org.asynchttpclient.spnego.SpnegoEngineException;
import gigahorse.shaded.ahc.org.asynchttpclient.uri.Uri;
import gigahorse.shaded.ahc.org.asynchttpclient.util.Base64;
import gigahorse.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class AuthenticatorUtils {
    public static final String NEGOTIATE = "Negotiate";

    public static String getHeaderWithPrefix(List<String> authenticateHeaders, String prefix) {
        if (authenticateHeaders != null) {
            for (String authenticateHeader : authenticateHeaders) {
                if (!authenticateHeader.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                return authenticateHeader;
            }
        }
        return null;
    }

    public static String computeBasicAuthentication(Realm realm) {
        return realm != null ? AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset()) : null;
    }

    private static String computeBasicAuthentication(String principal, String password, Charset charset) {
        String s = principal + ":" + password;
        return "Basic " + Base64.encode(s.getBytes(charset));
    }

    public static String computeRealmURI(Realm realm) {
        return AuthenticatorUtils.computeRealmURI(realm.getUri(), realm.isUseAbsoluteURI(), realm.isOmitQuery());
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = HttpUtils.getNonEmptyPath(uri);
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    private static String computeDigestAuthentication(Realm realm) {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", AuthenticatorUtils.computeRealmURI(realm), true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1));
    }

    private static StringBuilder append(StringBuilder builder, String name, String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        return builder.append(", ");
    }

    public static String perConnectionProxyAuthorizationHeader(Request request, Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    List<String> auth = request.getHeaders().getAll("Proxy-Authorization");
                    if (AuthenticatorUtils.getHeaderWithPrefix(auth, "NTLM") != null) break;
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    proxyAuthorization = "NTLM " + msg;
                    break;
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perRequestProxyAuthorizationHeader(Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case BASIC: {
                    proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyRealm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(proxyRealm.getNonce())) break;
                    proxyAuthorization = AuthenticatorUtils.computeDigestAuthentication(proxyRealm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)proxyRealm.getScheme()));
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perConnectionAuthorizationHeader(Request request, ProxyServer proxyServer, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case NTLM: {
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    authorizationHeader = "NTLM " + msg;
                    break;
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request.getVirtualHost() != null ? request.getVirtualHost() : request.getUri().getHost());
                    try {
                        authorizationHeader = "Negotiate " + SpnegoEngine.instance().generateToken(host);
                        break;
                    }
                    catch (SpnegoEngineException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return authorizationHeader;
    }

    public static String perRequestAuthorizationHeader(Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return authorizationHeader;
    }
}

