/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.request.body.multipart;

import gigahorse.shaded.ahc.org.asynchttpclient.request.body.multipart.PartBase;
import gigahorse.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.activation.MimetypesFileTypeMap;

public abstract class FileLikePart
extends PartBase {
    private static final MimetypesFileTypeMap MIME_TYPES_FILE_TYPE_MAP;
    private String fileName;

    private static String computeContentType(String contentType, String fileName) {
        if (contentType == null) {
            contentType = MIME_TYPES_FILE_TYPE_MAP.getContentType(MiscUtils.withDefault(fileName, ""));
        }
        return contentType;
    }

    public FileLikePart(String name, String contentType, Charset charset, String fileName, String contentId, String transfertEncoding) {
        super(name, FileLikePart.computeContentType(contentType, fileName), charset, contentId, transfertEncoding);
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String toString() {
        return super.toString() + " filename=" + this.fileName;
    }

    static {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("ahc-mime.types");){
            MIME_TYPES_FILE_TYPE_MAP = new MimetypesFileTypeMap(is);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

