/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.oauth;

import gigahorse.shaded.ahc.org.asynchttpclient.Request;
import gigahorse.shaded.ahc.org.asynchttpclient.RequestBuilderBase;
import gigahorse.shaded.ahc.org.asynchttpclient.SignatureCalculator;
import gigahorse.shaded.ahc.org.asynchttpclient.oauth.ConsumerKey;
import gigahorse.shaded.ahc.org.asynchttpclient.oauth.OAuthSignatureCalculatorInstance;
import gigahorse.shaded.ahc.org.asynchttpclient.oauth.RequestToken;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class OAuthSignatureCalculator
implements SignatureCalculator {
    private static final ThreadLocal<OAuthSignatureCalculatorInstance> INSTANCES = new ThreadLocal<OAuthSignatureCalculatorInstance>(){

        @Override
        protected OAuthSignatureCalculatorInstance initialValue() {
            try {
                return new OAuthSignatureCalculatorInstance();
            }
            catch (NoSuchAlgorithmException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    };
    private final ConsumerKey consumerAuth;
    private final RequestToken userAuth;

    public OAuthSignatureCalculator(ConsumerKey consumerAuth, RequestToken userAuth) {
        this.consumerAuth = consumerAuth;
        this.userAuth = userAuth;
    }

    @Override
    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        try {
            INSTANCES.get().sign(this.consumerAuth, this.userAuth, request, requestBuilder);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Failed to compute a valid key from consumer and user secrets", e);
        }
    }
}

