/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.util;

import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.Unpooled;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.util.Utf8ByteBufCharsetDecoder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class ByteBufUtils {
    private ByteBufUtils() {
    }

    public static String byteBuf2String(Charset charset, ByteBuf buf) throws CharacterCodingException {
        if (charset.equals(StandardCharsets.UTF_8) || charset.equals(StandardCharsets.US_ASCII)) {
            return Utf8ByteBufCharsetDecoder.decodeUtf8(buf);
        }
        return buf.toString(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeNonOptimized(Charset charset, ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            buf.retain();
        }
        ByteBuf composite = Unpooled.wrappedBuffer(bufs);
        try {
            String string = composite.toString(charset);
            return string;
        }
        finally {
            composite.release();
        }
    }

    public static String byteBuf2String(Charset charset, ByteBuf ... bufs) throws CharacterCodingException {
        if (charset.equals(StandardCharsets.UTF_8) || charset.equals(StandardCharsets.US_ASCII)) {
            return Utf8ByteBufCharsetDecoder.decodeUtf8(bufs);
        }
        return ByteBufUtils.decodeNonOptimized(charset, bufs);
    }

    public static byte[] byteBuf2Bytes(ByteBuf buf) {
        byte[] array;
        int readable = buf.readableBytes();
        int readerIndex = buf.readerIndex();
        if (buf.hasArray()) {
            array = buf.array();
            if (buf.arrayOffset() == 0 && readerIndex == 0 && array.length == readable) {
                return array;
            }
        }
        array = new byte[readable];
        buf.getBytes(readerIndex, array);
        return array;
    }
}

