/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.timeout;

import gigahorse.shaded.ahc.io.netty.util.Timeout;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import gigahorse.shaded.ahc.org.asynchttpclient.util.DateUtils;

public class ReadTimeoutTimerTask
extends TimeoutTimerTask {
    private final long readTimeout;

    public ReadTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int readTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.readTimeout = readTimeout;
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        if (this.nettyResponseFuture.isDone()) {
            this.timeoutsHolder.cancel();
            return;
        }
        long now = DateUtils.unpreciseMillisTime();
        long currentReadTimeoutInstant = this.readTimeout + this.nettyResponseFuture.getLastTouch();
        long durationBeforeCurrentReadTimeout = currentReadTimeoutInstant - now;
        if (durationBeforeCurrentReadTimeout <= 0L) {
            String message = "Read timeout to " + this.timeoutsHolder.remoteAddress() + " after " + this.readTimeout + " ms";
            long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
            this.expire(message, durationSinceLastTouch);
            this.timeoutsHolder.cancel();
        } else {
            this.done.set(false);
            this.timeoutsHolder.startReadTimeout(this);
        }
    }
}

