/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.request;

import gigahorse.shaded.ahc.io.netty.channel.Channel;
import gigahorse.shaded.ahc.org.asynchttpclient.handler.ProgressAsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.future.StackTraceInspector;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteListener.class);
    protected final NettyResponseFuture<?> future;
    protected final ProgressAsyncHandler<?> progressAsyncHandler;
    protected final boolean notifyHeaders;

    public WriteListener(NettyResponseFuture<?> future, boolean notifyHeaders) {
        this.future = future;
        this.progressAsyncHandler = future.getAsyncHandler() instanceof ProgressAsyncHandler ? (ProgressAsyncHandler)future.getAsyncHandler() : null;
        this.notifyHeaders = notifyHeaders;
    }

    private boolean abortOnThrowable(Channel channel, Throwable cause) {
        if (cause != null) {
            if (cause instanceof IllegalStateException || cause instanceof ClosedChannelException || StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                LOGGER.debug(cause.getMessage(), cause);
                Channels.silentlyCloseChannel(channel);
            } else {
                this.future.abort(cause);
            }
            return true;
        }
        return false;
    }

    protected void operationComplete(Channel channel, Throwable cause) {
        this.future.touch();
        if (this.abortOnThrowable(channel, cause)) {
            return;
        }
        if (this.progressAsyncHandler != null) {
            boolean startPublishing;
            boolean bl = startPublishing = !this.future.isInAuth() && !this.future.isInProxyAuth();
            if (startPublishing) {
                if (this.notifyHeaders) {
                    this.progressAsyncHandler.onHeadersWritten();
                } else {
                    this.progressAsyncHandler.onContentWritten();
                }
            }
        }
    }
}

