/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.request;

import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.Unpooled;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.DefaultFullHttpRequest;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.DefaultHttpRequest;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpMethod;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpVersion;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.Realm;
import gigahorse.shaded.ahc.org.asynchttpclient.Request;
import gigahorse.shaded.ahc.org.asynchttpclient.cookie.CookieEncoder;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.NettyRequest;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBodyBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyByteArrayBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyByteBufferBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyCompositeByteArrayBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyDirectBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyFileBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyInputStreamBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyMultipartBody;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyReactiveStreamsBody;
import gigahorse.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator.FileBodyGenerator;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import gigahorse.shaded.ahc.org.asynchttpclient.uri.Uri;
import gigahorse.shaded.ahc.org.asynchttpclient.util.AuthenticatorUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.StringUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.ws.WebSocketUtils;
import java.nio.charset.Charset;

public final class NettyRequestFactory {
    public static final String BROTLY_ACCEPT_ENCODING_SUFFIX = ", br";
    public static final String GZIP_DEFLATE = "gzip,deflate";
    private final AsyncHttpClientConfig config;

    public NettyRequestFactory(AsyncHttpClientConfig config) {
        this.config = config;
    }

    private NettyBody body(Request request, boolean connect) {
        NettyBody nettyBody = null;
        if (!connect) {
            Charset bodyCharset = MiscUtils.withDefault(request.getCharset(), HttpUtils.DEFAULT_CHARSET);
            if (request.getByteData() != null) {
                nettyBody = new NettyByteArrayBody(request.getByteData());
            } else if (request.getCompositeByteData() != null) {
                nettyBody = new NettyCompositeByteArrayBody(request.getCompositeByteData());
            } else if (request.getStringData() != null) {
                nettyBody = new NettyByteBufferBody(StringUtils.charSequence2ByteBuffer(request.getStringData(), bodyCharset));
            } else if (request.getByteBufferData() != null) {
                nettyBody = new NettyByteBufferBody(request.getByteBufferData());
            } else if (request.getStreamData() != null) {
                nettyBody = new NettyInputStreamBody(request.getStreamData());
            } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
                String contentType = null;
                if (!request.getHeaders().contains("Content-Type")) {
                    contentType = "application/x-www-form-urlencoded";
                }
                nettyBody = new NettyByteBufferBody(HttpUtils.urlEncodeFormParams(request.getFormParams(), bodyCharset), contentType);
            } else if (MiscUtils.isNonEmpty(request.getBodyParts())) {
                nettyBody = new NettyMultipartBody(request.getBodyParts(), request.getHeaders(), this.config);
            } else if (request.getFile() != null) {
                nettyBody = new NettyFileBody(request.getFile(), this.config);
            } else if (request.getBodyGenerator() instanceof FileBodyGenerator) {
                FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request.getBodyGenerator();
                nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.config);
            } else if (request.getBodyGenerator() instanceof InputStreamBodyGenerator) {
                InputStreamBodyGenerator inStreamGenerator = (InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request.getBodyGenerator());
                nettyBody = new NettyInputStreamBody(inStreamGenerator.getInputStream(), inStreamGenerator.getContentLength());
            } else if (request.getBodyGenerator() instanceof ReactiveStreamsBodyGenerator) {
                ReactiveStreamsBodyGenerator reactiveStreamsBodyGenerator = (ReactiveStreamsBodyGenerator)request.getBodyGenerator();
                nettyBody = new NettyReactiveStreamsBody(reactiveStreamsBodyGenerator.getPublisher(), reactiveStreamsBodyGenerator.getContentLength());
            } else if (request.getBodyGenerator() != null) {
                nettyBody = new NettyBodyBody(request.getBodyGenerator().createBody(), this.config);
            }
        }
        return nettyBody;
    }

    public void addAuthorizationHeader(HttpHeaders headers, String authorizationHeader) {
        if (authorizationHeader != null) {
            headers.add("Authorization", (Object)authorizationHeader);
        }
    }

    public void setProxyAuthorizationHeader(HttpHeaders headers, String proxyAuthorizationHeader) {
        if (proxyAuthorizationHeader != null) {
            headers.set("Proxy-Authorization", (Object)proxyAuthorizationHeader);
        }
    }

    public NettyRequest newNettyRequest(Request request, boolean forceConnect, ProxyServer proxyServer, Realm realm, Realm proxyRealm) {
        String connectionHeaderValue;
        NettyRequest nettyRequest;
        DefaultHttpRequest httpRequest;
        Uri uri = request.getUri();
        HttpMethod method = forceConnect ? HttpMethod.CONNECT : HttpMethod.valueOf(request.getMethod());
        boolean connect = method == HttpMethod.CONNECT;
        HttpVersion httpVersion = HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, connect);
        NettyBody body = this.body(request, connect);
        if (body instanceof NettyDirectBody) {
            ByteBuf buf = ((NettyDirectBody)NettyDirectBody.class.cast(body)).byteBuf();
            httpRequest = new DefaultFullHttpRequest(httpVersion, method, requestUri, buf);
            nettyRequest = new NettyRequest(httpRequest, null);
        } else if (body == null) {
            httpRequest = new DefaultFullHttpRequest(httpVersion, method, requestUri, Unpooled.EMPTY_BUFFER);
            nettyRequest = new NettyRequest(httpRequest, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest(httpRequest, body);
        }
        HttpHeaders headers = httpRequest.headers();
        if (connect) {
            headers.set("Proxy-Authorization", (Iterable<?>)request.getHeaders().getAll("Proxy-Authorization"));
        } else {
            String userDefinedAcceptEncoding;
            headers.set(request.getHeaders());
            if (MiscUtils.isNonEmpty(request.getCookies())) {
                headers.set("Cookie", (Object)CookieEncoder.encode(request.getCookies()));
            }
            if ((userDefinedAcceptEncoding = headers.get("Accept-Encoding")) != null) {
                if (userDefinedAcceptEncoding.endsWith(BROTLY_ACCEPT_ENCODING_SUFFIX)) {
                    headers.set("Accept-Encoding", (Object)userDefinedAcceptEncoding.subSequence(0, userDefinedAcceptEncoding.length() - BROTLY_ACCEPT_ENCODING_SUFFIX.length()));
                }
            } else if (this.config.isCompressionEnforced()) {
                headers.set("Accept-Encoding", (Object)GZIP_DEFLATE);
            }
        }
        if (body != null) {
            if (body.getContentLength() < 0L) {
                headers.set("Transfer-Encoding", (Object)"chunked");
            } else {
                headers.set("Content-Length", (Object)body.getContentLength());
            }
            if (body.getContentType() != null) {
                headers.set("Content-Type", (Object)body.getContentType());
            }
        }
        if (!connect && uri.isWebSocket()) {
            headers.set("Upgrade", (Object)"WebSocket").set("Connection", (Object)"Upgrade").set("Sec-WebSocket-Key", (Object)WebSocketUtils.getKey()).set("Sec-WebSocket-Version", (Object)"13");
            if (!headers.contains("Origin")) {
                headers.set("Origin", (Object)HttpUtils.computeOriginHeader(uri));
            }
        } else if (!headers.contains("Connection") && (connectionHeaderValue = this.connectionHeader(this.config.isKeepAlive(), httpVersion)) != null) {
            headers.set("Connection", (Object)connectionHeaderValue);
        }
        if (!headers.contains("Host")) {
            headers.set("Host", (Object)HttpUtils.hostHeader(request, uri));
        }
        this.addAuthorizationHeader(headers, AuthenticatorUtils.perRequestAuthorizationHeader(realm));
        if (!uri.isSecured() || connect) {
            this.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perRequestProxyAuthorizationHeader(proxyRealm));
        }
        if (!headers.contains("Accept")) {
            headers.set("Accept", (Object)"*/*");
        }
        if (!headers.contains("User-Agent") && this.config.getUserAgent() != null) {
            headers.set("User-Agent", (Object)this.config.getUserAgent());
        }
        return nettyRequest;
    }

    private String requestUri(Uri uri, ProxyServer proxyServer, boolean connect) {
        if (connect) {
            return HttpUtils.getAuthority(uri);
        }
        if (proxyServer != null && !uri.isSecured()) {
            return uri.toUrl();
        }
        String path = HttpUtils.getNonEmptyPath(uri);
        if (MiscUtils.isNonEmpty(uri.getQuery())) {
            return path + "?" + uri.getQuery();
        }
        return path;
    }

    private String connectionHeader(boolean keepAlive, HttpVersion httpVersion) {
        if (httpVersion.isKeepAliveDefault()) {
            return keepAlive ? null : "close";
        }
        return keepAlive ? "keep-alive" : null;
    }
}

