/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.future;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;

public class StackTraceInspector {
    private static boolean exceptionInMethod(Throwable t, String className, String methodName) {
        try {
            for (StackTraceElement element : t.getStackTrace()) {
                if (!element.getClassName().equals(className) || !element.getMethodName().equals(methodName)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean recoverOnConnectCloseException(Throwable t) {
        return StackTraceInspector.exceptionInMethod(t, "sun.nio.ch.SocketChannelImpl", "checkConnect") || t.getCause() != null && StackTraceInspector.recoverOnConnectCloseException(t.getCause());
    }

    public static boolean recoverOnNettyDisconnectException(Throwable t) {
        return t instanceof ClosedChannelException || StackTraceInspector.exceptionInMethod(t, "gigahorse.shaded.ahc.io.netty.handler.ssl.SslHandler", "disconnect") || t.getCause() != null && StackTraceInspector.recoverOnConnectCloseException(t.getCause());
    }

    public static boolean recoverOnReadOrWriteException(Throwable t) {
        if (t instanceof IOException && "Connection reset by peer".equalsIgnoreCase(t.getMessage())) {
            return true;
        }
        try {
            for (StackTraceElement element : t.getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (!className.equals("sun.nio.ch.SocketDispatcher") || !methodName.equals("read") && !methodName.equals("write")) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (t.getCause() != null) {
            return StackTraceInspector.recoverOnReadOrWriteException(t.getCause());
        }
        return false;
    }
}

