/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.channel;

import gigahorse.shaded.ahc.io.netty.bootstrap.Bootstrap;
import gigahorse.shaded.ahc.io.netty.bootstrap.ChannelFactory;
import gigahorse.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import gigahorse.shaded.ahc.io.netty.channel.Channel;
import gigahorse.shaded.ahc.io.netty.channel.ChannelHandler;
import gigahorse.shaded.ahc.io.netty.channel.ChannelInitializer;
import gigahorse.shaded.ahc.io.netty.channel.ChannelOption;
import gigahorse.shaded.ahc.io.netty.channel.ChannelPipeline;
import gigahorse.shaded.ahc.io.netty.channel.EventLoopGroup;
import gigahorse.shaded.ahc.io.netty.channel.group.ChannelGroup;
import gigahorse.shaded.ahc.io.netty.channel.group.DefaultChannelGroup;
import gigahorse.shaded.ahc.io.netty.channel.nio.NioEventLoopGroup;
import gigahorse.shaded.ahc.io.netty.channel.oio.OioEventLoopGroup;
import gigahorse.shaded.ahc.io.netty.channel.socket.nio.NioSocketChannel;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpClientCodec;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpContentDecompressor;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import gigahorse.shaded.ahc.io.netty.handler.logging.LogLevel;
import gigahorse.shaded.ahc.io.netty.handler.logging.LoggingHandler;
import gigahorse.shaded.ahc.io.netty.handler.ssl.SslHandler;
import gigahorse.shaded.ahc.io.netty.handler.stream.ChunkedWriteHandler;
import gigahorse.shaded.ahc.io.netty.util.AttributeKey;
import gigahorse.shaded.ahc.io.netty.util.Timer;
import gigahorse.shaded.ahc.io.netty.util.concurrent.DefaultThreadFactory;
import gigahorse.shaded.ahc.io.netty.util.concurrent.GlobalEventExecutor;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import gigahorse.shaded.ahc.org.asynchttpclient.channel.ChannelPool;
import gigahorse.shaded.ahc.org.asynchttpclient.channel.ChannelPoolPartitioning;
import gigahorse.shaded.ahc.org.asynchttpclient.channel.NoopChannelPool;
import gigahorse.shaded.ahc.org.asynchttpclient.exception.PoolAlreadyClosedException;
import gigahorse.shaded.ahc.org.asynchttpclient.exception.TooManyConnectionsException;
import gigahorse.shaded.ahc.org.asynchttpclient.exception.TooManyConnectionsPerHostException;
import gigahorse.shaded.ahc.org.asynchttpclient.handler.AsyncHandlerExtensions;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.OnLastHttpContentCallback;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.DefaultChannelPool;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.NioSocketChannelFactory;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphore;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphoreInfinite;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphoreLike;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.NoopHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.handler.HttpHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.handler.WebSocketHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.ssl.DefaultSslEngineFactory;
import gigahorse.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import gigahorse.shaded.ahc.org.asynchttpclient.uri.Uri;
import gigahorse.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    public static final String PINNED_ENTRY = "entry";
    public static final String HTTP_CLIENT_CODEC = "http";
    public static final String SSL_HANDLER = "ssl";
    public static final String DEFLATER_HANDLER = "deflater";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunked-writer";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    public static final String AHC_HTTP_HANDLER = "ahc-http";
    public static final String AHC_WS_HANDLER = "ahc-ws";
    public static final String LOGGING_HANDLER = "logging";
    private static final AttributeKey<Object> partitionKeyAttr = AttributeKey.valueOf("partitionKey");
    private final AsyncHttpClientConfig config;
    private final SslEngineFactory sslEngineFactory;
    private final EventLoopGroup eventLoopGroup;
    private final boolean allowReleaseEventLoopGroup;
    private final Bootstrap httpBootstrap;
    private final Bootstrap wsBootstrap;
    private final long handshakeTimeout;
    private final IOException tooManyConnections;
    private final IOException tooManyConnectionsPerHost;
    private final ChannelPool channelPool;
    private final ChannelGroup openChannels;
    private final boolean maxTotalConnectionsEnabled;
    private final NonBlockingSemaphoreLike freeChannels;
    private final boolean maxConnectionsPerHostEnabled;
    private final ConcurrentHashMap<Object, NonBlockingSemaphore> freeChannelsPerHost = new ConcurrentHashMap();
    private AsyncHttpClientHandler wsHandler;

    public ChannelManager(AsyncHttpClientConfig config, Timer nettyTimer) {
        ChannelFactory<NioSocketChannel> channelFactory;
        this.config = config;
        this.sslEngineFactory = config.getSslEngineFactory() != null ? config.getSslEngineFactory() : new DefaultSslEngineFactory();
        try {
            this.sslEngineFactory.init(config);
        }
        catch (SSLException e) {
            throw new RuntimeException("Could not initialize sslEngineFactory", e);
        }
        ChannelPool channelPool = config.getChannelPool();
        if (channelPool == null) {
            channelPool = config.isKeepAlive() ? new DefaultChannelPool(config, nettyTimer) : NoopChannelPool.INSTANCE;
        }
        this.channelPool = channelPool;
        this.tooManyConnections = MiscUtils.trimStackTrace(new TooManyConnectionsException(config.getMaxConnections()));
        this.tooManyConnectionsPerHost = MiscUtils.trimStackTrace(new TooManyConnectionsPerHostException(config.getMaxConnectionsPerHost()));
        this.maxTotalConnectionsEnabled = config.getMaxConnections() > 0;
        this.maxConnectionsPerHostEnabled = config.getMaxConnectionsPerHost() > 0;
        this.freeChannels = this.maxTotalConnectionsEnabled ? new NonBlockingSemaphore(config.getMaxConnections()) : NonBlockingSemaphoreInfinite.INSTANCE;
        this.openChannels = this.maxTotalConnectionsEnabled || this.maxConnectionsPerHostEnabled ? new DefaultChannelGroup("asyncHttpClient", GlobalEventExecutor.INSTANCE){

            @Override
            public boolean remove(Object o) {
                boolean removed = super.remove(o);
                if (removed) {
                    NonBlockingSemaphore hostFreeChannels;
                    Object partitionKey;
                    ChannelManager.this.freeChannels.release();
                    if (ChannelManager.this.maxConnectionsPerHostEnabled && (partitionKey = ((Channel)Channel.class.cast(o)).attr(partitionKeyAttr).getAndSet(null)) != null && (hostFreeChannels = (NonBlockingSemaphore)ChannelManager.this.freeChannelsPerHost.get(partitionKey)) != null) {
                        hostFreeChannels.release();
                    }
                }
                return removed;
            }
        } : new DefaultChannelGroup("asyncHttpClient", GlobalEventExecutor.INSTANCE);
        this.handshakeTimeout = config.getHandshakeTimeout();
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName());
        boolean bl = this.allowReleaseEventLoopGroup = config.getEventLoopGroup() == null;
        if (this.allowReleaseEventLoopGroup) {
            if (config.isUseNativeTransport()) {
                this.eventLoopGroup = this.newEpollEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = this.getEpollSocketChannelFactory();
            } else {
                this.eventLoopGroup = new NioEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = NioSocketChannelFactory.INSTANCE;
            }
        } else {
            this.eventLoopGroup = config.getEventLoopGroup();
            if (this.eventLoopGroup instanceof OioEventLoopGroup) {
                throw new IllegalArgumentException("Oio is not supported");
            }
            channelFactory = this.eventLoopGroup instanceof NioEventLoopGroup ? NioSocketChannelFactory.INSTANCE : this.getEpollSocketChannelFactory();
        }
        this.httpBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.wsBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.httpBootstrap.option(ChannelOption.AUTO_READ, false);
    }

    private Bootstrap newBootstrap(ChannelFactory<? extends Channel> channelFactory, EventLoopGroup eventLoopGroup, AsyncHttpClientConfig config) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(channelFactory)).group(eventLoopGroup)).option(ChannelOption.ALLOCATOR, config.getAllocator() != null ? config.getAllocator() : ByteBufAllocator.DEFAULT)).option(ChannelOption.TCP_NODELAY, config.isTcpNoDelay())).option(ChannelOption.SO_REUSEADDR, config.isSoReuseAddress())).option(ChannelOption.AUTO_CLOSE, false);
        if (config.getConnectTimeout() > 0) {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, config.getConnectTimeout());
        }
        if (config.getSoLinger() >= 0) {
            bootstrap.option(ChannelOption.SO_LINGER, config.getSoLinger());
        }
        if (config.getSoSndBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, config.getSoSndBuf());
        }
        if (config.getSoRcvBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, config.getSoRcvBuf());
        }
        for (Map.Entry<ChannelOption<Object>, Object> entry : config.getChannelOptions().entrySet()) {
            bootstrap.option(entry.getKey(), entry.getValue());
        }
        return bootstrap;
    }

    private EventLoopGroup newEpollEventLoopGroup(int ioThreadsCount, ThreadFactory threadFactory) {
        try {
            Class<?> epollEventLoopGroupClass = Class.forName("gigahorse.shaded.ahc.io.netty.channel.epoll.EpollEventLoopGroup");
            return (EventLoopGroup)epollEventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(ioThreadsCount, threadFactory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ChannelFactory<? extends Channel> getEpollSocketChannelFactory() {
        try {
            return (ChannelFactory)Class.forName("gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.EpollSocketChannelFactory").newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureBootstraps(NettyRequestSender requestSender) {
        final HttpHandler httpHandler = new HttpHandler(this.config, this, requestSender);
        this.wsHandler = new WebSocketHandler(this.config, this, requestSender);
        final NoopHandler pinnedEntry = new NoopHandler();
        final LoggingHandler loggingHandler = new LoggingHandler(LogLevel.TRACE);
        this.httpBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.PINNED_ENTRY, (ChannelHandler)pinnedEntry).addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor()).addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(ChannelManager.AHC_HTTP_HANDLER, (ChannelHandler)httpHandler);
                if (LOGGER.isTraceEnabled()) {
                    pipeline.addAfter(ChannelManager.PINNED_ENTRY, ChannelManager.LOGGING_HANDLER, loggingHandler);
                }
                if (ChannelManager.this.config.getHttpAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getHttpAdditionalChannelInitializer().initChannel(ch);
                }
            }
        });
        this.wsBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.PINNED_ENTRY, (ChannelHandler)pinnedEntry).addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.AHC_WS_HANDLER, (ChannelHandler)ChannelManager.this.wsHandler);
                if (LOGGER.isDebugEnabled()) {
                    pipeline.addAfter(ChannelManager.PINNED_ENTRY, ChannelManager.LOGGING_HANDLER, loggingHandler);
                }
                if (ChannelManager.this.config.getWsAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getWsAdditionalChannelInitializer().initChannel(ch);
                }
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.config.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                @Override
                protected String getTargetContentEncoding(String contentEncoding) throws Exception {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, AsyncHandler<?> asyncHandler, boolean keepAlive, Object partitionKey) {
        if (channel.isActive() && keepAlive) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            if (asyncHandler instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onConnectionOffer(channel);
            }
            if (this.channelPool.offer(channel, partitionKey)) {
                if (this.maxConnectionsPerHostEnabled) {
                    channel.attr(partitionKeyAttr).setIfAbsent(partitionKey);
                }
                return;
            }
        }
        this.releaseChannelLock(partitionKey);
        this.closeChannel(channel);
    }

    public Channel poll(Uri uri, String virtualHost, ProxyServer proxy, ChannelPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, virtualHost, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public boolean removeAll(Channel connection) {
        return this.channelPool.removeAll(connection);
    }

    private boolean tryAcquireGlobal() {
        return this.freeChannels.tryAcquire();
    }

    private NonBlockingSemaphoreLike getFreeConnectionsForHost(Object partitionKey) {
        return this.maxConnectionsPerHostEnabled ? (NonBlockingSemaphoreLike)this.freeChannelsPerHost.computeIfAbsent(partitionKey, pk -> new NonBlockingSemaphore(this.config.getMaxConnectionsPerHost())) : NonBlockingSemaphoreInfinite.INSTANCE;
    }

    private boolean tryAcquirePerHost(Object partitionKey) {
        return this.getFreeConnectionsForHost(partitionKey).tryAcquire();
    }

    public void acquireChannelLock(Object partitionKey) throws IOException {
        if (!this.channelPool.isOpen()) {
            throw PoolAlreadyClosedException.INSTANCE;
        }
        if (!this.tryAcquireGlobal()) {
            throw this.tooManyConnections;
        }
        if (!this.tryAcquirePerHost(partitionKey)) {
            this.freeChannels.release();
            throw this.tooManyConnectionsPerHost;
        }
    }

    private void doClose() {
        this.openChannels.close();
        this.channelPool.destroy();
    }

    public void close() {
        if (this.allowReleaseEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully(this.config.getShutdownQuietPeriod(), this.config.getShutdownTimeout(), TimeUnit.MILLISECONDS).addListener(future -> this.doClose());
        } else {
            this.doClose();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        Channels.setDiscard(channel);
        this.removeAll(channel);
        Channels.silentlyCloseChannel(channel);
    }

    public void releaseChannelLock(Object partitionKey) {
        this.freeChannels.release();
        this.getFreeConnectionsForHost(partitionKey).release();
    }

    public void registerOpenChannel(Channel channel, Object partitionKey) {
        this.openChannels.add(channel);
        if (this.maxConnectionsPerHostEnabled) {
            channel.attr(partitionKeyAttr).set(partitionKey);
        }
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.config.getHttpClientCodecMaxInitialLineLength(), this.config.getHttpClientCodecMaxHeaderSize(), this.config.getHttpClientCodecMaxChunkSize(), false, this.config.isValidateResponseHeaders());
    }

    private SslHandler createSslHandler(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslEngineFactory.newSslEngine(this.config, peerHost, peerPort);
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeout > 0L) {
            sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeout);
        }
        return sslHandler;
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    public void upgradeProtocol(ChannelPipeline pipeline, Uri requestUri) throws SSLException {
        if (pipeline.get(HTTP_CLIENT_CODEC) != null) {
            pipeline.remove(HTTP_CLIENT_CODEC);
        }
        if (requestUri.isSecured()) {
            if (ChannelManager.isSslHandlerConfigured(pipeline)) {
                pipeline.addAfter(SSL_HANDLER, HTTP_CLIENT_CODEC, this.newHttpClientCodec());
            } else {
                pipeline.addAfter(PINNED_ENTRY, HTTP_CLIENT_CODEC, this.newHttpClientCodec());
                pipeline.addAfter(PINNED_ENTRY, SSL_HANDLER, this.createSslHandler(requestUri.getHost(), requestUri.getExplicitPort()));
            }
        } else {
            pipeline.addAfter(PINNED_ENTRY, HTTP_CLIENT_CODEC, this.newHttpClientCodec());
        }
        if (requestUri.isWebSocket()) {
            pipeline.addAfter(AHC_HTTP_HANDLER, AHC_WS_HANDLER, this.wsHandler);
            pipeline.remove(AHC_HTTP_HANDLER);
        }
    }

    public SslHandler addSslHandler(ChannelPipeline pipeline, Uri uri, String virtualHost) {
        int peerPort;
        String peerHost;
        if (virtualHost != null) {
            int i = virtualHost.indexOf(58);
            if (i == -1) {
                peerHost = virtualHost;
                peerPort = uri.getSchemeDefaultPort();
            } else {
                peerHost = virtualHost.substring(0, i);
                peerPort = Integer.valueOf(virtualHost.substring(i + 1));
            }
        } else {
            peerHost = uri.getHost();
            peerPort = uri.getExplicitPort();
        }
        SslHandler sslHandler = this.createSslHandler(peerHost, peerPort);
        pipeline.addFirst(SSL_HANDLER, (ChannelHandler)sslHandler);
        return sslHandler;
    }

    public Bootstrap getBootstrap(Uri uri, ProxyServer proxy) {
        return uri.isWebSocket() && proxy == null ? this.wsBootstrap : this.httpBootstrap;
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_CLIENT_CODEC, WS_ENCODER_HANDLER, new WebSocket08FrameEncoder(true));
        pipeline.addBefore(AHC_WS_HANDLER, WS_DECODER_HANDLER, new WebSocket08FrameDecoder(false, false, this.config.getWebSocketMaxFrameSize()));
        pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, new WebSocketFrameAggregator(this.config.getWebSocketMaxBufferSize()));
        pipeline.remove(HTTP_CLIENT_CODEC);
    }

    public final OnLastHttpContentCallback newDrainCallback(NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final Object partitionKey) {
        return new OnLastHttpContentCallback(future){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, this.future.getAsyncHandler(), keepAlive, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future) {
        this.drainChannelAndOffer(channel, future, future.isKeepAlive(), future.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future, boolean keepAlive, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future, channel, keepAlive, partitionKey));
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }
}

