/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty;

import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseHeaders;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import gigahorse.shaded.ahc.org.asynchttpclient.Response;
import gigahorse.shaded.ahc.org.asynchttpclient.cookie.Cookie;
import gigahorse.shaded.ahc.org.asynchttpclient.cookie.CookieDecoder;
import gigahorse.shaded.ahc.org.asynchttpclient.uri.Uri;
import gigahorse.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NettyResponse
implements Response {
    private final List<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private List<Cookie> cookies;

    public NettyResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        this.bodyParts = bodyParts;
        this.headers = headers;
        this.status = status;
    }

    private List<Cookie> buildCookies() {
        List<String> setCookieHeaders = this.headers.getHeaders().getAll("Set-Cookie2");
        if (!MiscUtils.isNonEmpty(setCookieHeaders)) {
            setCookieHeaders = this.headers.getHeaders().getAll("Set-Cookie");
        }
        if (MiscUtils.isNonEmpty(setCookieHeaders)) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>(1);
            for (String value : setCookieHeaders) {
                Cookie c = CookieDecoder.decode(value);
                if (c == null) continue;
                cookies.add(c);
            }
            return Collections.unmodifiableList(cookies);
        }
        return Collections.emptyList();
    }

    @Override
    public final int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public final String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public final Uri getUri() {
        return this.status.getUri();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.status.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.status.getLocalAddress();
    }

    @Override
    public final String getContentType() {
        return this.headers != null ? this.getHeader("Content-Type") : null;
    }

    @Override
    public final String getHeader(String name) {
        return this.headers != null ? this.getHeaders().get(name) : null;
    }

    @Override
    public final List<String> getHeaders(String name) {
        return this.headers != null ? this.getHeaders().getAll(name) : Collections.emptyList();
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers != null ? this.headers.getHeaders() : HttpHeaders.EMPTY_HEADERS;
    }

    @Override
    public final boolean isRedirected() {
        switch (this.status.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            this.cookies = this.buildCookies();
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null && !this.headers.getHeaders().isEmpty();
    }

    @Override
    public boolean hasResponseBody() {
        return MiscUtils.isNonEmpty(this.bodyParts);
    }

    @Override
    public byte[] getResponseBodyAsBytes() {
        return this.getResponseBodyAsByteBuffer().array();
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() {
        int length = 0;
        for (HttpResponseBodyPart part : this.bodyParts) {
            length += part.length();
        }
        ByteBuffer target = ByteBuffer.wrap(new byte[length]);
        for (HttpResponseBodyPart part : this.bodyParts) {
            target.put(part.getBodyPartBytes());
        }
        target.flip();
        return target;
    }

    @Override
    public String getResponseBody() {
        return this.getResponseBody(null);
    }

    private Charset computeCharset(Charset charset) {
        String contentType;
        if (charset == null && (contentType = this.getContentType()) != null) {
            charset = HttpUtils.parseCharset(contentType);
        }
        return charset != null ? charset : HttpUtils.DEFAULT_CHARSET;
    }

    @Override
    public String getResponseBody(Charset charset) {
        return new String(this.getResponseBodyAsBytes(), this.computeCharset(charset));
    }

    @Override
    public InputStream getResponseBodyAsStream() {
        return new ByteArrayInputStream(this.getResponseBodyAsBytes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" {\n").append("\tstatusCode=").append(this.getStatusCode()).append("\n").append("\theaders=\n");
        for (Map.Entry header : this.getHeaders()) {
            sb.append("\t\t").append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\n");
        }
        sb.append("\tbody=\n").append(this.getResponseBody()).append("\n").append("}").toString();
        return sb.toString();
    }
}

