/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient;

import gigahorse.shaded.ahc.io.netty.channel.EventLoopGroup;
import gigahorse.shaded.ahc.io.netty.util.HashedWheelTimer;
import gigahorse.shaded.ahc.io.netty.util.Timer;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncCompletionHandlerBase;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClientState;
import gigahorse.shaded.ahc.org.asynchttpclient.BoundRequestBuilder;
import gigahorse.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.ListenableFuture;
import gigahorse.shaded.ahc.org.asynchttpclient.Request;
import gigahorse.shaded.ahc.org.asynchttpclient.RequestBuilder;
import gigahorse.shaded.ahc.org.asynchttpclient.Response;
import gigahorse.shaded.ahc.org.asynchttpclient.SignatureCalculator;
import gigahorse.shaded.ahc.org.asynchttpclient.channel.ChannelPool;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.FilterContext;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.FilterException;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.RequestFilter;
import gigahorse.shaded.ahc.org.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import gigahorse.shaded.ahc.org.asynchttpclient.util.Assertions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncHttpClient
implements AsyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncHttpClient.class);
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    protected SignatureCalculator signatureCalculator;

    public DefaultAsyncHttpClient() {
        this(new DefaultAsyncHttpClientConfig.Builder().build());
    }

    public DefaultAsyncHttpClient(AsyncHttpClientConfig config) {
        this.config = config;
        this.allowStopNettyTimer = config.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer() : config.getNettyTimer();
        this.channelManager = new ChannelManager(config, this.nettyTimer);
        this.requestSender = new NettyRequestSender(config, this.channelManager, this.nettyTimer, new AsyncHttpClientState(this.closed));
        this.channelManager.configureBootstraps(this.requestSender);
    }

    private Timer newNettyTimer() {
        HashedWheelTimer timer = new HashedWheelTimer();
        timer.start();
        return timer;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channelManager.close();
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on ChannelManager close", t);
            }
            if (this.allowStopNettyTimer) {
                try {
                    this.nettyTimer.stop();
                }
                catch (Throwable t) {
                    LOGGER.warn("Unexpected error on HashedWheelTimer close", t);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DefaultAsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    @Override
    public BoundRequestBuilder prepareGet(String url) {
        return this.requestBuilder("GET", url);
    }

    @Override
    public BoundRequestBuilder prepareConnect(String url) {
        return this.requestBuilder("CONNECT", url);
    }

    @Override
    public BoundRequestBuilder prepareOptions(String url) {
        return this.requestBuilder("OPTIONS", url);
    }

    @Override
    public BoundRequestBuilder prepareHead(String url) {
        return this.requestBuilder("HEAD", url);
    }

    @Override
    public BoundRequestBuilder preparePost(String url) {
        return this.requestBuilder("POST", url);
    }

    @Override
    public BoundRequestBuilder preparePut(String url) {
        return this.requestBuilder("PUT", url);
    }

    @Override
    public BoundRequestBuilder prepareDelete(String url) {
        return this.requestBuilder("DELETE", url);
    }

    @Override
    public BoundRequestBuilder preparePatch(String url) {
        return this.requestBuilder("PATCH", url);
    }

    @Override
    public BoundRequestBuilder prepareTrace(String url) {
        return this.requestBuilder("TRACE", url);
    }

    @Override
    public BoundRequestBuilder prepareRequest(Request request) {
        return this.requestBuilder(request);
    }

    @Override
    public BoundRequestBuilder prepareRequest(RequestBuilder requestBuilder) {
        return this.prepareRequest(requestBuilder.build());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) {
        if (this.config.getRequestFilters().isEmpty()) {
            return this.execute(request, handler);
        }
        FilterContext fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(handler).request(request).build();
        try {
            fc = this.preProcessRequest(fc);
        }
        catch (Exception e) {
            handler.onThrowable(e);
            return new ListenableFuture.CompletedFailure("preProcessRequest failed", e);
        }
        return this.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(RequestBuilder requestBuilder, AsyncHandler<T> handler) {
        return this.executeRequest(requestBuilder.build(), handler);
    }

    @Override
    public ListenableFuture<Response> executeRequest(Request request) {
        return this.executeRequest(request, new AsyncCompletionHandlerBase());
    }

    @Override
    public ListenableFuture<Response> executeRequest(RequestBuilder requestBuilder) {
        return this.executeRequest(requestBuilder.build());
    }

    private <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) {
        try {
            return this.requestSender.sendRequest(request, asyncHandler, null, false);
        }
        catch (Exception e) {
            asyncHandler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
    }

    private <T> FilterContext<T> preProcessRequest(FilterContext<T> fc) throws FilterException {
        for (RequestFilter asyncFilter : this.config.getRequestFilters()) {
            fc = asyncFilter.filter(fc);
            Assertions.assertNotNull(fc, "filterContext");
        }
        Request request = fc.getRequest();
        if (fc.getAsyncHandler() instanceof ResumableAsyncHandler) {
            request = ((ResumableAsyncHandler)ResumableAsyncHandler.class.cast(fc.getAsyncHandler())).adjustRequestRange(request);
        }
        if (request.getRangeOffset() != 0L) {
            RequestBuilder builder = new RequestBuilder(request);
            builder.setHeader((CharSequence)"Range", "bytes=" + request.getRangeOffset() + "-");
            request = builder.build();
        }
        fc = new FilterContext.FilterContextBuilder<T>(fc).request(request).build();
        return fc;
    }

    public ChannelPool getChannelPool() {
        return this.channelManager.getChannelPool();
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.channelManager.getEventLoopGroup();
    }

    protected BoundRequestBuilder requestBuilder(String method, String url) {
        return (BoundRequestBuilder)((BoundRequestBuilder)new BoundRequestBuilder(this, method, this.config.isDisableUrlEncodingForBoundRequests()).setUrl(url)).setSignatureCalculator(this.signatureCalculator);
    }

    protected BoundRequestBuilder requestBuilder(Request prototype) {
        return (BoundRequestBuilder)new BoundRequestBuilder(this, prototype).setSignatureCalculator(this.signatureCalculator);
    }
}

