/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient;

import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import gigahorse.shaded.ahc.io.netty.channel.Channel;
import gigahorse.shaded.ahc.io.netty.channel.ChannelOption;
import gigahorse.shaded.ahc.io.netty.channel.EventLoopGroup;
import gigahorse.shaded.ahc.io.netty.handler.ssl.SslContext;
import gigahorse.shaded.ahc.io.netty.util.Timer;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import gigahorse.shaded.ahc.org.asynchttpclient.Realm;
import gigahorse.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import gigahorse.shaded.ahc.org.asynchttpclient.channel.ChannelPool;
import gigahorse.shaded.ahc.org.asynchttpclient.channel.KeepAliveStrategy;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.IOExceptionFilter;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.RequestFilter;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.ResponseFilter;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.EagerResponseBodyPart;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.LazyResponseBodyPart;
import gigahorse.shaded.ahc.org.asynchttpclient.proxy.ProxyServerSelector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;

public interface AsyncHttpClientConfig {
    public String getAhcVersion();

    public String getThreadPoolName();

    public int getMaxConnections();

    public int getMaxConnectionsPerHost();

    public int getConnectTimeout();

    public int getReadTimeout();

    public int getPooledConnectionIdleTimeout();

    public int getConnectionPoolCleanerPeriod();

    public int getRequestTimeout();

    public boolean isFollowRedirect();

    public int getMaxRedirects();

    public boolean isKeepAlive();

    public String getUserAgent();

    public boolean isCompressionEnforced();

    public ThreadFactory getThreadFactory();

    public ProxyServerSelector getProxyServerSelector();

    public SslContext getSslContext();

    public Realm getRealm();

    public List<RequestFilter> getRequestFilters();

    public List<ResponseFilter> getResponseFilters();

    public List<IOExceptionFilter> getIoExceptionFilters();

    public int getMaxRequestRetry();

    public boolean isDisableUrlEncodingForBoundRequests();

    public boolean isStrict302Handling();

    public int getConnectionTtl();

    public boolean isUseOpenSsl();

    public boolean isAcceptAnyCertificate();

    public String[] getEnabledProtocols();

    public String[] getEnabledCipherSuites();

    public int getSslSessionCacheSize();

    public int getSslSessionTimeout();

    public int getHttpClientCodecMaxInitialLineLength();

    public int getHttpClientCodecMaxHeaderSize();

    public int getHttpClientCodecMaxChunkSize();

    public boolean isDisableZeroCopy();

    public int getHandshakeTimeout();

    public SslEngineFactory getSslEngineFactory();

    public int getChunkedFileChunkSize();

    public int getWebSocketMaxBufferSize();

    public int getWebSocketMaxFrameSize();

    public boolean isKeepEncodingHeader();

    public int getShutdownQuietPeriod();

    public int getShutdownTimeout();

    public Map<ChannelOption<Object>, Object> getChannelOptions();

    public EventLoopGroup getEventLoopGroup();

    public boolean isUseNativeTransport();

    public AdditionalChannelInitializer getHttpAdditionalChannelInitializer();

    public AdditionalChannelInitializer getWsAdditionalChannelInitializer();

    public ResponseBodyPartFactory getResponseBodyPartFactory();

    public ChannelPool getChannelPool();

    public Timer getNettyTimer();

    public KeepAliveStrategy getKeepAliveStrategy();

    public boolean isValidateResponseHeaders();

    public boolean isTcpNoDelay();

    public boolean isSoReuseAddress();

    public int getSoLinger();

    public int getSoSndBuf();

    public int getSoRcvBuf();

    public ByteBufAllocator getAllocator();

    public int getIoThreadsCount();

    public static enum ResponseBodyPartFactory {
        EAGER{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new EagerResponseBodyPart(buf, last);
            }
        }
        ,
        LAZY{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new LazyResponseBodyPart(buf, last);
            }
        };


        public abstract HttpResponseBodyPart newResponseBodyPart(ByteBuf var1, boolean var2);
    }

    public static interface AdditionalChannelInitializer {
        public void initChannel(Channel var1) throws Exception;
    }
}

