/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.io.netty.handler.codec.protobuf;

import com.google.protobuf.CodedInputStream;
import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import gigahorse.shaded.ahc.io.netty.handler.codec.ByteToMessageDecoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.CorruptedFrameException;
import java.util.List;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < buf.length; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            buf[i] = in.readByte();
            if (buf[i] < 0) continue;
            int length = CodedInputStream.newInstance((byte[])buf, (int)0, (int)(i + 1)).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            out.add(in.readSlice(length).retain());
            return;
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }
}

