/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.io.netty.channel;

import gigahorse.shaded.ahc.io.netty.channel.Channel;
import gigahorse.shaded.ahc.io.netty.channel.ChannelFuture;
import gigahorse.shaded.ahc.io.netty.channel.ChannelPromise;
import gigahorse.shaded.ahc.io.netty.channel.EventLoop;
import gigahorse.shaded.ahc.io.netty.channel.EventLoopGroup;
import gigahorse.shaded.ahc.io.netty.util.NettyRuntime;
import gigahorse.shaded.ahc.io.netty.util.concurrent.DefaultThreadFactory;
import gigahorse.shaded.ahc.io.netty.util.concurrent.MultithreadEventExecutorGroup;
import gigahorse.shaded.ahc.io.netty.util.internal.SystemPropertyUtil;
import gigahorse.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import gigahorse.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ThreadFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("gigahorse.shaded.ahc.io.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

