/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.core5.http.impl;

import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Contract;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.hc.core5.http.ContentLengthStrategy;
import gigahorse.shaded.apache.org.apache.hc.core5.http.Header;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpException;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpMessage;
import gigahorse.shaded.apache.org.apache.hc.core5.http.NotImplementedException;
import gigahorse.shaded.apache.org.apache.hc.core5.http.ProtocolException;
import gigahorse.shaded.apache.org.apache.hc.core5.http.message.MessageSupport;
import gigahorse.shaded.apache.org.apache.hc.core5.util.Args;
import gigahorse.shaded.apache.org.apache.hc.core5.util.TextUtils;
import java.util.concurrent.atomic.AtomicReference;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultContentLengthStrategy
implements ContentLengthStrategy {
    public static final DefaultContentLengthStrategy INSTANCE = new DefaultContentLengthStrategy();

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "HTTP message");
        Header teh = message.getFirstHeader("Transfer-Encoding");
        if (teh != null) {
            AtomicReference codingRef = new AtomicReference();
            MessageSupport.parseTokens(message, "Transfer-Encoding", e -> {
                if (!TextUtils.isBlank(e)) {
                    if (e.equalsIgnoreCase("chunked")) {
                        if (!codingRef.compareAndSet(null, Coding.CHUNK)) {
                            codingRef.set(Coding.UNKNOWN);
                        }
                    } else {
                        codingRef.set(Coding.UNKNOWN);
                    }
                }
            });
            if (codingRef.get() == Coding.CHUNK) {
                return -1L;
            }
            throw new NotImplementedException("Unsupported transfer encoding: " + teh.getValue());
        }
        if (message.countHeaders("Content-Length") > 1) {
            throw new ProtocolException("Multiple Content-Length headers");
        }
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            String s = contentLengthHeader.getValue();
            try {
                long len = Long.parseLong(s);
                if (len < 0L) {
                    throw new ProtocolException("Negative content length: " + s);
                }
                return len;
            }
            catch (NumberFormatException e2) {
                throw new ProtocolException("Invalid content length: " + s);
            }
        }
        return -9223372036854775807L;
    }

    static enum Coding {
        UNKNOWN,
        CHUNK;

    }
}

