/*
 * Decompiled with CFR 0.152.
 */
package com.edmodo.cropper.util;

import android.graphics.Rect;

public class AspectRatioUtil {
    public static float calculateAspectRatio(float left, float top, float right, float bottom) {
        float width = right - left;
        float height = bottom - top;
        float aspectRatio = width / height;
        return aspectRatio;
    }

    public static float calculateAspectRatio(Rect rect) {
        float aspectRatio = (float)rect.width() / (float)rect.height();
        return aspectRatio;
    }

    public static float calculateLeft(float top, float right, float bottom, float targetAspectRatio) {
        float height = bottom - top;
        float left = right - targetAspectRatio * height;
        return left;
    }

    public static float calculateTop(float left, float right, float bottom, float targetAspectRatio) {
        float width = right - left;
        float top = bottom - width / targetAspectRatio;
        return top;
    }

    public static float calculateRight(float left, float top, float bottom, float targetAspectRatio) {
        float height = bottom - top;
        float right = targetAspectRatio * height + left;
        return right;
    }

    public static float calculateBottom(float left, float top, float right, float targetAspectRatio) {
        float width = right - left;
        float bottom = width / targetAspectRatio + top;
        return bottom;
    }

    public static float calculateWidth(float top, float bottom, float targetAspectRatio) {
        float height = bottom - top;
        float width = targetAspectRatio * height;
        return width;
    }

    public static float calculateHeight(float left, float right, float targetAspectRatio) {
        float width = right - left;
        float height = width / targetAspectRatio;
        return height;
    }
}

