/*
 * Decompiled with CFR 0.152.
 */
package com.ederdoski.simpleble.utils;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.ederdoski.simpleble.interfaces.BleCallback;
import com.ederdoski.simpleble.models.BluetoothLE;
import com.ederdoski.simpleble.utils.Functions;
import com.ederdoski.simpleble.utils.Permissions;
import java.util.ArrayList;
import java.util.UUID;

public class BluetoothLEHelper {
    private Activity act;
    private ArrayList<BluetoothLE> aDevices = new ArrayList();
    private BleCallback bleCallback;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothAdapter mBluetoothAdapter;
    private static final int STATE_DISCONNECTED = 0;
    private static final int STATE_CONNECTED = 1;
    private int mConnectionState = 0;
    private static long SCAN_PERIOD = 10000L;
    private static boolean mScanning = false;
    private static String FILTER_SERVICE = "";
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(final BluetoothDevice device, final int rssi, byte[] scanRecord) {
            BluetoothLEHelper.this.act.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothLEHelper.this.aDevices.size() > 0) {
                        boolean isNewItem = true;
                        for (int i = 0; i < BluetoothLEHelper.this.aDevices.size(); ++i) {
                            if (!((BluetoothLE)BluetoothLEHelper.this.aDevices.get(i)).getMacAddress().equals(device.getAddress())) continue;
                            isNewItem = false;
                        }
                        if (isNewItem) {
                            BluetoothLEHelper.this.aDevices.add(new BluetoothLE(device.getName(), device.getAddress(), rssi, device));
                        }
                    } else {
                        BluetoothLEHelper.this.aDevices.add(new BluetoothLE(device.getName(), device.getAddress(), rssi, device));
                    }
                }
            });
        }
    };
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (newState == 2) {
                Log.i((String)"BluetoothLEHelper", (String)("Attempting to start service discovery: " + BluetoothLEHelper.this.mBluetoothGatt.discoverServices()));
                BluetoothLEHelper.this.mConnectionState = 1;
            }
            if (newState == 0) {
                BluetoothLEHelper.this.mConnectionState = 0;
            }
            BluetoothLEHelper.this.bleCallback.onBleConnectionStateChange(gatt, status, newState);
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            BluetoothLEHelper.this.bleCallback.onBleServiceDiscovered(gatt, status);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            BluetoothLEHelper.this.bleCallback.onBleWrite(gatt, characteristic, status);
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            BluetoothLEHelper.this.bleCallback.onBleRead(gatt, characteristic, status);
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            BluetoothLEHelper.this.bleCallback.onBleCharacteristicChange(gatt, characteristic);
        }
    };

    public BluetoothLEHelper(Activity _act) {
        if (Functions.isBleSupported(_act)) {
            this.act = _act;
            BluetoothManager bluetoothManager = (BluetoothManager)this.act.getSystemService("bluetooth");
            this.mBluetoothAdapter = bluetoothManager.getAdapter();
            this.mBluetoothAdapter.enable();
        }
    }

    public void scanLeDevice(boolean enable) {
        Handler mHandler = new Handler();
        if (enable) {
            mScanning = true;
            mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    mScanning = false;
                    BluetoothLEHelper.this.mBluetoothAdapter.stopLeScan(BluetoothLEHelper.this.mLeScanCallback);
                }
            }, SCAN_PERIOD);
            if (!FILTER_SERVICE.equals("")) {
                UUID[] filter = new UUID[]{UUID.fromString(FILTER_SERVICE)};
                this.mBluetoothAdapter.startLeScan(filter, this.mLeScanCallback);
            } else {
                this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
            }
        } else {
            mScanning = false;
            this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        }
    }

    public ArrayList<BluetoothLE> getListDevices() {
        return this.aDevices;
    }

    public void connect(BluetoothDevice device, BleCallback _bleCallback) {
        if (this.mBluetoothGatt == null && !this.isConnected()) {
            this.bleCallback = _bleCallback;
            this.mBluetoothGatt = device.connectGatt((Context)this.act, false, this.mGattCallback);
        }
    }

    public void disconnect() {
        if (this.mBluetoothGatt != null && this.isConnected()) {
            this.mBluetoothGatt.close();
            this.mBluetoothGatt = null;
        }
    }

    public boolean isReadyForScan() {
        return Permissions.checkPermisionStatus(this.act, "android.permission.BLUETOOTH") && Permissions.checkPermisionStatus(this.act, "android.permission.BLUETOOTH_ADMIN") && Permissions.checkPermisionStatus(this.act, "android.permission.ACCESS_COARSE_LOCATION") && Functions.getStatusGps(this.act);
    }

    public void write(String service, String characteristic, byte[] aBytes) {
        BluetoothGattCharacteristic mBluetoothGattCharacteristic = this.mBluetoothGatt.getService(UUID.fromString(service)).getCharacteristic(UUID.fromString(characteristic));
        mBluetoothGattCharacteristic.setValue(aBytes);
        this.mBluetoothGatt.writeCharacteristic(mBluetoothGattCharacteristic);
    }

    public void write(String service, String characteristic, String aData) {
        BluetoothGattCharacteristic mBluetoothGattCharacteristic = this.mBluetoothGatt.getService(UUID.fromString(service)).getCharacteristic(UUID.fromString(characteristic));
        mBluetoothGattCharacteristic.setValue(aData);
        this.mBluetoothGatt.writeCharacteristic(mBluetoothGattCharacteristic);
    }

    public void read(String service, String characteristic) {
        this.mBluetoothGatt.readCharacteristic(this.mBluetoothGatt.getService(UUID.fromString(service)).getCharacteristic(UUID.fromString(characteristic)));
    }

    public boolean isConnected() {
        return this.mConnectionState == 1;
    }

    public boolean isScanning() {
        return mScanning;
    }

    public void setScanPeriod(int scanPeriod) {
        SCAN_PERIOD = scanPeriod;
    }

    public long getScanPeriod() {
        return SCAN_PERIOD;
    }

    public void setFilterService(String filterService) {
        FILTER_SERVICE = filterService;
    }

    public BluetoothGattCallback getGatt() {
        return this.mGattCallback;
    }
}

