/*
 * Decompiled with CFR 0.152.
 */
package com.eddmash.pagination;

import android.util.Log;
import com.eddmash.db.ActiveRecord;
import com.eddmash.pagination.DataListener;
import com.eddmash.pagination.Paginator;
import java.util.List;
import java.util.Map;

public class SqlPaginator
extends Paginator {
    private String _sql;
    private String[] _params;
    private ActiveRecord activeRecord;

    public SqlPaginator(DataListener dataListener, ActiveRecord activeRecord) {
        super(dataListener);
        this.activeRecord = activeRecord;
    }

    public void query(String sql, String[] params) {
        this._sql = sql;
        this._params = params;
        this._currentRecordsCounter = this.pageSize;
        this._totalRecords = this.activeRecord.getScalarInt("select count(*) from (" + sql + ")", params);
        Log.e((String)this.getClass().getName(), (String)("COUNT TOTAL " + this._totalRecords));
        new Paginator.LoadDataTask().execute(new Integer[]{0, this.pageSize});
    }

    @Override
    protected List<Map> getNextPageRecords(int startPoint, int endPoint) {
        String sql = this._sql + " limit " + this.pageSize + " offset " + startPoint;
        Log.e((String)this.getClass().getSimpleName(), (String)(startPoint + " to " + endPoint + " (" + sql + ")"));
        return this.activeRecord.find(sql, this._params);
    }
}

