/*
 * Decompiled with CFR 0.152.
 */
package com.eddmash.pagination;

import android.os.AsyncTask;
import android.util.Log;
import com.eddmash.pagination.DataListener;
import com.eddmash.pagination.PaginatorInterface;
import java.util.List;
import java.util.Map;

public abstract class Paginator
implements PaginatorInterface {
    protected int pageSize;
    private boolean populating = false;
    protected int currentPage;
    public int newPageStartPoint;
    protected int _totalRecords;
    protected int _currentRecordsCounter;
    protected boolean isLastPage = false;
    protected int _pageCount = 1;
    protected String logTag = this.getClass().getName();
    protected DataListener dataListener;

    public Paginator(DataListener dataListener) {
        this.dataListener = dataListener;
        this.pageSize = 20;
        this.currentPage = 1;
        this._totalRecords = 0;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void fetchNextPageData() {
        if (!this.populating && !this.isLastPage) {
            ++this.currentPage;
            this.newPageStartPoint = (this.currentPage - 1) * this.pageSize;
            int last = this.pageSize + this.newPageStartPoint;
            int size = this._totalRecords;
            this.updatePageCount();
            if (size <= last) {
                last = this._totalRecords;
                this.isLastPage = true;
            }
            Log.e((String)this.logTag, (String)("GETTING NEXT PAGE " + this.currentPage + " isLastPage " + this.isLastPage));
            this.dataListener.preDataLoad(last <= this._totalRecords);
            if (size >= this.newPageStartPoint) {
                new LoadDataTask().execute(new Integer[]{this.newPageStartPoint, last});
            }
        }
    }

    private void updatePageCount() {
        if (this._totalRecords > this.pageSize) {
            Double pageCount = Math.ceil(this._totalRecords / this.pageSize) + 1.0;
            this._pageCount = pageCount.intValue();
        }
    }

    @Override
    public int getPageCount() {
        return this._pageCount;
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    public String getCurrentPageString() {
        return "( page " + this.getCurrentPage() + " of " + this.getPageCount() + ")";
    }

    protected abstract List<Map> getNextPageRecords(int var1, int var2);

    @Override
    public int getTotalRecords() {
        return this._totalRecords;
    }

    protected class LoadDataTask
    extends AsyncTask<Integer, Void, Void> {
        protected LoadDataTask() {
        }

        protected Void doInBackground(Integer ... params) {
            Paginator.this.populating = true;
            int startPoint = params[0];
            int endPoint = params[1];
            List<Map> data = Paginator.this.getNextPageRecords(startPoint, endPoint);
            Paginator.this._currentRecordsCounter += data.size();
            Paginator.this.dataListener.dataUpdate(data);
            return null;
        }

        protected void onPostExecute(Void done) {
            Paginator.this.populating = false;
            if (Paginator.this.isLastPage) {
                Paginator.this.dataListener.onLastPageDataLoaded();
            }
            if (Paginator.this.currentPage == 1) {
                Paginator.this.updatePageCount();
                Paginator.this.dataListener.onFirstPageDataLoaded(Paginator.this._currentRecordsCounter < Paginator.this._totalRecords);
            }
            if (Paginator.this.currentPage != 1 && !Paginator.this.isLastPage) {
                Paginator.this.dataListener.onNextPageDataLoaded();
            }
        }
    }
}

