/*
 * Decompiled with CFR 0.152.
 */
package com.eddmash.pagination;

import android.os.AsyncTask;
import android.util.Log;
import com.eddmash.db.ActiveRecord;
import com.eddmash.pagination.ListPaginator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class SqlPaginator
extends ListPaginator {
    private String _sql;
    private String[] _params;
    private ActiveRecord activeRecord;

    public SqlPaginator(ActiveRecord activeRecord) {
        this.activeRecord = activeRecord;
    }

    public void query(String sql, String[] params) {
        this._sql = sql;
        Log.e((String)"LERER", (String)Arrays.toString(params));
        this._params = params;
        this._totalRecords = this.activeRecord.getScalarInt("select count(*) from (" + sql + ")", params);
        Log.e((String)this.getClass().getName(), (String)("COUNT TOTAL " + this._totalRecords));
        if (this._totalRecords > this.pageSize) {
            sql = sql + " limit " + this.pageSize;
        }
        new LoadTask().execute(new String[]{sql});
    }

    @Override
    protected List<Map> getNextPageRecords(int newPageStartPoint, int last) {
        Log.e((String)"LMITI", (String)(newPageStartPoint + " to " + last));
        String sql = this._sql + " limit " + this.pageSize + " offset " + newPageStartPoint;
        return this.activeRecord.find(sql, this._params);
    }

    private class LoadTask
    extends AsyncTask<String, Void, Void> {
        private LoadTask() {
        }

        protected Void doInBackground(String ... params) {
            Log.e((String)"POLOPO", (String)(params[0] + " " + Arrays.toString(SqlPaginator.this._params)));
            SqlPaginator.this._paginatedRecords = SqlPaginator.this.activeRecord.find(params[0], SqlPaginator.this._params);
            Log.e((String)((Object)((Object)this)).getClass().getName(), (String)("DATA " + SqlPaginator.this._paginatedRecords));
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            boolean hasMorePages = false;
            if (SqlPaginator.this._totalRecords > SqlPaginator.this.pageSize) {
                Double pageCount = Math.ceil(SqlPaginator.this._totalRecords / SqlPaginator.this.pageSize);
                SqlPaginator.this.setPageCount(1 + pageCount.intValue());
                hasMorePages = true;
            }
            SqlPaginator.this.OnFirstPageLoad(hasMorePages);
        }
    }
}

