/*
 * Decompiled with CFR 0.152.
 */
package com.eddmash.pagination;

import android.os.AsyncTask;
import android.util.Log;
import com.eddmash.pagination.PaginatorInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ListPaginator
implements PaginatorInterface {
    protected int currentPage = 1;
    protected int pageSize = 20;
    private List _records = new ArrayList();
    protected List _paginatedRecords = new ArrayList();
    private int _pageCount = 1;
    protected String logTag = this.getClass().getName();
    public int newPageStartPoint;
    private boolean populating = false;
    protected int _totalRecords = 0;

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setStartPage(int startPage) {
        this.currentPage = startPage;
    }

    @Override
    public void nextPage() {
        ++this.currentPage;
        this.newPageStartPoint = (this.currentPage - 1) * this.pageSize;
        int last = this.pageSize + this.newPageStartPoint;
        Log.e((String)this.logTag, (String)("GETTING NEXT PAGE " + this.currentPage));
        int size = this._totalRecords;
        if (size <= last) {
            last = this._totalRecords;
            this.onLastPageLoad();
        }
        if (size >= this.newPageStartPoint && !this.populating) {
            this.OnNextPageLoad(last <= this._records.size());
            new AddMoreTask().execute(new Integer[]{this.newPageStartPoint, last});
        }
    }

    @Override
    public List<Map> getData() {
        return this._paginatedRecords;
    }

    public void setData(List<Map> results) {
        Log.e((String)this.logTag, (String)("SET DATA" + results.size()));
        boolean hasMorePages = false;
        this._records = results;
        this._totalRecords = this._records.size();
        this._paginatedRecords = this._totalRecords < this.pageSize ? this._records : this._records.subList(0, this.pageSize);
        if (this._totalRecords > this.pageSize) {
            Double pageCount = Math.ceil(this._totalRecords / this.pageSize) + 1.0;
            this._pageCount = pageCount.intValue();
            hasMorePages = true;
        }
        this.OnFirstPageLoad(hasMorePages);
    }

    @Override
    public int getPageCount() {
        return this._pageCount;
    }

    public void setPageCount(int _pageCount) {
        this._pageCount = _pageCount;
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    public String getCurrentPageString() {
        return "( page " + this.getCurrentPage() + " of " + this.getPageCount() + ")";
    }

    protected List<Map> getNextPageRecords(int newPageStartPoint, int last) {
        return this._records.subList(this.newPageStartPoint, last);
    }

    public int getTotalRecords() {
        return this._totalRecords;
    }

    private class AddMoreTask
    extends AsyncTask<Integer, Void, Void> {
        private AddMoreTask() {
        }

        protected Void doInBackground(Integer ... params) {
            ListPaginator.this.populating = true;
            int newPageStartPoint = params[0];
            int last = params[1];
            ListPaginator.this.updateAdapter(ListPaginator.this.getNextPageRecords(newPageStartPoint, last));
            return null;
        }

        protected void onPostExecute(Void done) {
            ListPaginator.this.populating = false;
            ListPaginator.this.onDoneAddingRecords();
        }
    }
}

