/*
 * Decompiled with CFR 0.152.
 */
package com.eddmash.dialogs;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.eddmash.dialogs.R;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericDialog
extends DialogFragment {
    protected Button leftButton;
    protected Button rightButton;
    protected View layout;
    private ButtonClickedListener buttonListener;
    private TextView customTitleView;
    private ImageView customIconView;
    private boolean disableButtons = false;
    private int _layoutID = 0;
    private String title;
    private int icon;
    private Map<String, Map> buttonSettings = new HashMap<String, Map>();
    private final String RIGHTBUTTON = "RIGHTBTN";
    private final String LEFTBUTTON = "LEFTBTN";
    private Map titleSettings = new HashMap();

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.layout = inflater.inflate(R.layout.dialog_generic_body, container);
        if (this.getContentLayout() != 0) {
            View childView = this.getActivity().getLayoutInflater().inflate(this.getContentLayout(), null);
            LinearLayout lay = (LinearLayout)this.layout.findViewById(R.id.dialog_content);
            lay.addView(childView);
        }
        return this.layout;
    }

    protected int getContentLayout() {
        return this._layoutID;
    }

    public void setContentLayout(@LayoutRes int layoutID) {
        this._layoutID = layoutID;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getDialog().requestWindowFeature(1);
        this.customTitleView = (TextView)this.layout.findViewById(R.id.dialog_title);
        if (this.title != null) {
            this.customTitleView.setText((CharSequence)this.title);
        }
        this.customIconView = (ImageView)this.layout.findViewById(R.id.dialog_icon);
        if (this.icon != 0) {
            this.customIconView.setVisibility(0);
            this.customIconView.setImageDrawable(ContextCompat.getDrawable((Context)this.getActivity(), (int)this.icon));
        } else {
            this.customIconView.setVisibility(8);
        }
        this.leftButton = (Button)view.findViewById(R.id.btn_get_data_update);
        this.rightButton = (Button)view.findViewById(R.id.btn_update_later);
        this.leftButton.setVisibility(8);
        this.rightButton.setVisibility(8);
        this.getDialog().getWindow().setSoftInputMode(4);
        this.onViewReady(this.layout, savedInstanceState);
        this.addToView(this.layout);
        this.doTitleConfigurations();
        this.doButtonConfigutions();
    }

    private void doTitleConfigurations() {
        if (this.titleSettings.size() > 0) {
            int textColorId;
            int colorId;
            if (this.titleSettings.containsKey("bgColor") && (colorId = ((Integer)this.titleSettings.get("bgColor")).intValue()) > 0) {
                this.customTitleView.setBackgroundColor(this.getActivity().getResources().getColor(colorId));
            }
            if (this.titleSettings.containsKey("textColor") && (textColorId = ((Integer)this.titleSettings.get("textColor")).intValue()) > 0) {
                this.customTitleView.setTextColor(this.getActivity().getResources().getColor(textColorId));
            }
        }
    }

    private void doButtonConfigutions() {
        if (this.buttonSettings.size() > 0) {
            ButtonClickedListener lister;
            if (this.buttonSettings.containsKey("RIGHTBTN")) {
                Map rSettings = this.buttonSettings.get("RIGHTBTN");
                lister = (ButtonClickedListener)rSettings.get("listener");
                this.rightButton.setVisibility(0);
                this.rightButton.setText((CharSequence)rSettings.get("label").toString());
                this.rightButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        GenericDialog.this.bindButton(lister);
                    }
                });
            }
            if (this.buttonSettings.containsKey("LEFTBTN")) {
                Map lSettings = this.buttonSettings.get("LEFTBTN");
                lister = (ButtonClickedListener)lSettings.get("listener");
                this.leftButton.setVisibility(0);
                this.leftButton.setText((CharSequence)lSettings.get("label").toString());
                this.leftButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        GenericDialog.this.bindButton(lister);
                    }
                });
            }
        }
    }

    protected abstract void onViewReady(View var1, @Nullable Bundle var2);

    public void addToView(View layout2) {
    }

    public void setIcon(@DrawableRes int drawable) {
        this.icon = drawable;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setRightButton(String label, ButtonClickedListener clickListener) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("label", label);
        settings.put("listener", clickListener);
        this.buttonSettings.put("RIGHTBTN", settings);
    }

    public void setLeftButton(String label, ButtonClickedListener clickListener) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("label", label);
        settings.put("listener", clickListener);
        this.buttonSettings.put("LEFTBTN", settings);
    }

    private void bindButton(ButtonClickedListener buttonListener) {
        buttonListener.onClick(this.layout, this);
    }

    public void disableButtons(boolean b) {
        this.disableButtons = b;
    }

    public void setTitleBackground(@ColorRes int titleBgColor) {
        this.titleSettings.put("bgColor", titleBgColor);
    }

    public void setTitleTextColor(@ColorRes int titleBgColor) {
        this.titleSettings.put("textColor", titleBgColor);
    }

    public static class Dismiss
    implements ButtonClickedListener {
        @Override
        public void onClick(View view, DialogFragment dialog) {
            dialog.dismiss();
        }
    }

    public static interface ButtonClickedListener {
        public void onClick(View var1, DialogFragment var2);
    }
}

