/*
 * Decompiled with CFR 0.152.
 */
package com.eddmash.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActiveRecord {
    private static ActiveRecord instance;
    private SQLiteDatabase db;

    public SQLiteDatabase getDb() {
        return this.db;
    }

    private ActiveRecord(SQLiteDatabase database) {
        this.db = database;
    }

    public static ActiveRecord getInstance(SQLiteDatabase database) {
        if (instance == null) {
            instance = new ActiveRecord(database);
        }
        return instance;
    }

    public List<Map> find(String sql, String[] args) {
        Cursor mycursor = this.db.rawQuery(sql, args);
        ArrayList<Map> list = new ArrayList<Map>();
        while (mycursor.moveToNext()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String colName : mycursor.getColumnNames()) {
                map.put(colName, mycursor.getString(mycursor.getColumnIndexOrThrow(colName)));
            }
            list.add(map);
        }
        mycursor.close();
        return list;
    }

    public List<Map> all(String tableName, String[] queryCols) {
        Cursor mycursor = this.db.query(tableName, queryCols, null, null, null, null, null, null);
        if (queryCols == null) {
            queryCols = mycursor.getColumnNames();
        }
        Log.e((String)this.getClass().getName(), (String)("COLS :: " + Arrays.toString(queryCols)));
        ArrayList<Map> list = new ArrayList<Map>();
        while (mycursor.moveToNext()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String colName : queryCols) {
                map.put(colName, mycursor.getString(mycursor.getColumnIndexOrThrow(colName)));
            }
            list.add(map);
        }
        mycursor.close();
        return list;
    }

    public List<Map> all(String tableName) {
        Cursor mycursor = this.db.query(tableName, null, null, null, null, null, null, null);
        String[] queryCols = mycursor.getColumnNames();
        ArrayList<Map> list = new ArrayList<Map>();
        while (mycursor.moveToNext()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String colName : queryCols) {
                map.put(colName, mycursor.getString(mycursor.getColumnIndexOrThrow(colName)));
            }
            list.add(map);
        }
        mycursor.close();
        return list;
    }

    public boolean exists(String tableName, String field, String value) {
        Cursor cursor = this.db.query(tableName, null, field + " = ? ", new String[]{value}, null, null, null);
        if (cursor.getCount() <= 0) {
            cursor.close();
            return false;
        }
        cursor.close();
        return true;
    }

    public boolean exists(String sql, String[] params) {
        Cursor cursor = this.db.rawQuery(sql, params);
        if (cursor.getCount() <= 0) {
            cursor.close();
            return false;
        }
        cursor.close();
        return true;
    }

    public HashMap get(String sql, String[] params) {
        Cursor c = this.db.rawQuery(sql, params);
        String selection = "";
        HashMap<String, String> record = new HashMap<String, String>();
        if (c.moveToFirst()) {
            for (String col : c.getColumnNames()) {
                record.put(col, c.getString(c.getColumnIndexOrThrow(col)));
            }
        }
        c.close();
        return record;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.db.close();
    }

    public int getScalarInt(String sql, String[] params) {
        Cursor c = this.db.rawQuery(sql, params);
        int count = -1;
        if (c.moveToFirst()) {
            count = c.getInt(0);
        }
        c.close();
        return count;
    }
}

