/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.transport;

import com.ecwid.consul.transport.HttpRequest;
import com.ecwid.consul.transport.HttpResponse;
import com.ecwid.consul.transport.HttpTransport;
import com.ecwid.consul.transport.TransportException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public abstract class AbstractHttpTransport
implements HttpTransport {
    static final int DEFAULT_MAX_CONNECTIONS = 1000;
    static final int DEFAULT_MAX_PER_ROUTE_CONNECTIONS = 500;
    static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    static final int DEFAULT_READ_TIMEOUT = 600000;

    @Override
    public HttpResponse makeGetRequest(HttpRequest request) {
        HttpGet httpGet = new HttpGet(request.getUrl());
        this.addHeadersToRequest((HttpRequestBase)httpGet, request.getHeaders());
        return this.executeRequest((HttpUriRequest)httpGet);
    }

    @Override
    public HttpResponse makePutRequest(HttpRequest request) {
        HttpPut httpPut = new HttpPut(request.getUrl());
        this.addHeadersToRequest((HttpRequestBase)httpPut, request.getHeaders());
        if (request.getContent() != null) {
            httpPut.setEntity((HttpEntity)new StringEntity(request.getContent(), StandardCharsets.UTF_8));
        } else {
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(request.getBinaryContent()));
        }
        return this.executeRequest((HttpUriRequest)httpPut);
    }

    @Override
    public HttpResponse makeDeleteRequest(HttpRequest request) {
        HttpDelete httpDelete = new HttpDelete(request.getUrl());
        this.addHeadersToRequest((HttpRequestBase)httpDelete, request.getHeaders());
        return this.executeRequest((HttpUriRequest)httpDelete);
    }

    protected abstract HttpClient getHttpClient();

    private HttpResponse executeRequest(HttpUriRequest httpRequest) {
        try {
            return (HttpResponse)this.getHttpClient().execute(httpRequest, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                String statusMessage = response.getStatusLine().getReasonPhrase();
                String content = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                Long consulIndex = this.parseUnsignedLong(response.getFirstHeader("X-Consul-Index"));
                Boolean consulKnownLeader = this.parseBoolean(response.getFirstHeader("X-Consul-Knownleader"));
                Long consulLastContact = this.parseUnsignedLong(response.getFirstHeader("X-Consul-Lastcontact"));
                return new HttpResponse(statusCode, statusMessage, content, consulIndex, consulKnownLeader, consulLastContact);
            });
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private Long parseUnsignedLong(Header header) {
        if (header == null) {
            return null;
        }
        String value = header.getValue();
        if (value == null) {
            return null;
        }
        try {
            return Long.parseUnsignedLong(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Boolean parseBoolean(Header header) {
        if (header == null) {
            return null;
        }
        if ("true".equals(header.getValue())) {
            return true;
        }
        if ("false".equals(header.getValue())) {
            return false;
        }
        return null;
    }

    private void addHeadersToRequest(HttpRequestBase request, Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, String> headerValue : headers.entrySet()) {
            String name = headerValue.getKey();
            String value = headerValue.getValue();
            request.addHeader(name, value);
        }
    }
}

