/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.event;

import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.event.EventClient;
import com.ecwid.consul.v1.event.model.Event;
import com.ecwid.consul.v1.event.model.EventParams;
import com.google.gson.reflect.TypeToken;
import java.util.List;

public final class EventConsulClient
implements EventClient {
    private final ConsulRawClient rawClient;

    public EventConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    public EventConsulClient() {
        this(new ConsulRawClient());
    }

    public EventConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public EventConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    @Override
    public Response<Event> eventFire(String event, String payload, EventParams eventParams, QueryParams queryParams) {
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/event/fire/" + event, payload, eventParams, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            Event value = (Event)GsonFactory.getGson().fromJson(rawResponse.getContent(), Event.class);
            return new Response<Event>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<Event>> eventList(QueryParams queryParams) {
        return this.eventList(null, queryParams);
    }

    @Override
    public Response<List<Event>> eventList(String event, QueryParams queryParams) {
        SingleUrlParameters eventParams = event != null ? new SingleUrlParameters("name", event) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/event/list", eventParams, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Event>>(){}.getType());
            return new Response<List<Event>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }
}

