/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite.writer;

import com.ebay.xcelite.sheet.XceliteSheet;
import com.ebay.xcelite.writer.SheetWriter;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;

public abstract class SheetWriterAbs<T>
implements SheetWriter<T> {
    protected XceliteSheet sheet;
    protected boolean writeHeader;

    public SheetWriterAbs(XceliteSheet sheet, boolean writeHeader) {
        this.sheet = sheet;
        this.writeHeader = writeHeader;
    }

    protected void writeToCell(Cell cell, Object fieldValueObj, Class<?> dataType) {
        Class<?> type = fieldValueObj.getClass();
        if (dataType != null) {
            type = dataType;
        }
        if (type == Date.class) {
            cell.setCellValue((Date)fieldValueObj);
        } else if (type == Boolean.class) {
            cell.setCellValue(((Boolean)fieldValueObj).booleanValue());
        } else if (type == Double.class || type == Double.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Float.class || type == Float.TYPE || type == Short.class || type == Short.TYPE) {
            cell.setCellType(0);
            cell.setCellValue(Double.valueOf(fieldValueObj.toString()).doubleValue());
        } else {
            cell.setCellType(1);
            cell.setCellValue(fieldValueObj.toString());
        }
    }

    @Override
    public void generateHeaderRow(boolean generateHeaderRow) {
        this.writeHeader = generateHeaderRow;
    }

    @Override
    public XceliteSheet getSheet() {
        return this.sheet;
    }
}

