/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite.writer;

import com.ebay.xcelite.annotate.NoConverterClass;
import com.ebay.xcelite.column.Col;
import com.ebay.xcelite.column.ColumnsExtractor;
import com.ebay.xcelite.converters.ColumnValueConverter;
import com.ebay.xcelite.sheet.XceliteSheet;
import com.ebay.xcelite.styles.CellStylesBank;
import com.ebay.xcelite.writer.SheetWriterAbs;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.reflections.ReflectionUtils;

public class BeanSheetWriter<T>
extends SheetWriterAbs<T> {
    private final LinkedHashSet<Col> columns;
    private final Col anyColumn;
    private Row headerRow;
    private int rowIndex = 0;

    public BeanSheetWriter(XceliteSheet sheet, Class<T> type) {
        super(sheet, true);
        ColumnsExtractor extractor = new ColumnsExtractor(type);
        extractor.extract();
        this.columns = extractor.getColumns();
        this.anyColumn = extractor.getAnyColumn();
    }

    @Override
    public void write(Collection<T> data) {
        if (this.writeHeader) {
            this.writeHeader();
        }
        this.writeData(data);
    }

    private void writeData(Collection<T> data) {
        try {
            TreeSet columnsToAdd = Sets.newTreeSet();
            for (T t : data) {
                if (this.anyColumn == null) continue;
                this.appendAnyColumns(t, columnsToAdd);
            }
            this.addColumns(columnsToAdd, true);
            for (T t : data) {
                Row row = this.sheet.getNativeSheet().createRow(this.rowIndex);
                int i = 0;
                for (Col col : this.columns) {
                    Set fields = ReflectionUtils.getAllFields(t.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)col.getFieldName())});
                    Field field = (Field)fields.iterator().next();
                    field.setAccessible(true);
                    Object fieldValueObj = null;
                    if (col.isAnyColumn()) {
                        Map anyColumnMap = (Map)field.get(t);
                        fieldValueObj = anyColumnMap.get(col.getName());
                    } else {
                        fieldValueObj = field.get(t);
                    }
                    Cell cell = row.createCell(i);
                    this.writeToCell(cell, col, fieldValueObj);
                    ++i;
                }
                ++this.rowIndex;
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToCell(Cell cell, Col col, Object fieldValueObj) {
        if (fieldValueObj == null) {
            cell.setCellValue((String)null);
            return;
        }
        if (col.getConverter() != null) {
            try {
                ColumnValueConverter<?, ?> converter = col.getConverter().newInstance();
                fieldValueObj = converter.serialize(fieldValueObj);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (col.getDataFormat() != null) {
            cell.setCellStyle(CellStylesBank.get(this.sheet.getNativeSheet().getWorkbook()).getCustomDataFormatStyle(col.getDataFormat()));
        }
        if (col.getType() == Date.class && col.getDataFormat() == null) {
            cell.setCellStyle(CellStylesBank.get(this.sheet.getNativeSheet().getWorkbook()).getDateStyle());
        }
        this.writeToCell(cell, fieldValueObj, col.getType());
    }

    private void writeHeader() {
        this.headerRow = this.sheet.getNativeSheet().createRow(this.rowIndex);
        ++this.rowIndex;
        this.addColumns(this.columns, false);
    }

    private void appendAnyColumns(T t, Set<Col> columnToAdd) {
        try {
            Set fields = ReflectionUtils.getAllFields(t.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)this.anyColumn.getFieldName())});
            Field anyColumnField = (Field)fields.iterator().next();
            anyColumnField.setAccessible(true);
            Map fieldValueObj = (Map)anyColumnField.get(t);
            for (Map.Entry entry : fieldValueObj.entrySet()) {
                Col column = new Col((String)entry.getKey(), anyColumnField.getName());
                column.setType(entry.getValue() == null ? String.class : entry.getValue().getClass());
                column.setAnyColumn(true);
                if (this.anyColumn.getConverter() != NoConverterClass.class) {
                    column.setConverter(this.anyColumn.getConverter());
                }
                columnToAdd.add(column);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void addColumns(Set<Col> columnsToAdd, boolean append) {
        int i = this.headerRow == null || this.headerRow.getLastCellNum() == -1 ? 0 : this.headerRow.getLastCellNum();
        for (Col column : columnsToAdd) {
            if (append && this.columns.contains(column)) continue;
            Cell cell = this.headerRow.createCell(i);
            cell.setCellType(1);
            cell.setCellStyle(CellStylesBank.get(this.sheet.getNativeSheet().getWorkbook()).getBoldStyle());
            cell.setCellValue(column.getName());
            this.columns.add(column);
            ++i;
        }
    }
}

