/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite.utils.diff;

import com.ebay.xcelite.reader.SheetReader;
import com.ebay.xcelite.utils.diff.DiffResult;
import com.ebay.xcelite.utils.diff.info.Collections;
import com.ebay.xcelite.utils.diff.info.Files;
import com.ebay.xcelite.utils.diff.info.Info;
import com.ebay.xcelite.utils.diff.info.Sheets;
import com.ebay.xcelite.utils.diff.report.NewLineDecorator;
import com.ebay.xcelite.utils.diff.report.ReportGenerator;
import com.ebay.xcelite.utils.diff.report.ReportInfo;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;

public final class XceliteDiff {
    private static final String NEW_LINE = System.getProperty("line.separator");

    private XceliteDiff() {
    }

    public static <T> DiffResult<T> diff(@Nonnull SheetReader<T> a, @Nonnull SheetReader<T> b) {
        return XceliteDiff.diff(a, b, null);
    }

    public static <T> DiffResult<T> diff(@Nonnull SheetReader<T> a, @Nonnull SheetReader<T> b, ReportGenerator reportGenerator) {
        Collection<T> ca = a.read();
        Collection<T> cb = b.read();
        Collection disjunction = CollectionUtils.disjunction(ca, cb);
        ReportInfo<T> info = new ReportInfo<T>(new Files(a.getSheet().getFile().getAbsolutePath(), b.getSheet().getFile().getAbsolutePath()), new Sheets(a.getSheet().getNativeSheet().getSheetName(), b.getSheet().getNativeSheet().getSheetName()), new Collections<T>(ca, cb, disjunction));
        ReportGenerator reporter = reportGenerator != null ? reportGenerator : new SimpleReportGenerator();
        return new DiffResultImpl(disjunction, reporter.generateReport(info));
    }

    private static class SimpleReportGenerator
    implements ReportGenerator {
        private SimpleReportGenerator() {
        }

        @Override
        public <T> String generateReport(Info<T> info) {
            StringBuilder sb = new StringBuilder();
            sb.append("File " + info.files().aFile() + ", ");
            sb.append("Sheet: " + info.sheets().aSheetname() + ", ");
            sb.append(String.format("items (%s):" + NEW_LINE, info.collections().a().size()));
            sb.append(NEW_LINE);
            sb.append(new NewLineDecorator<T>(info.collections().a()));
            sb.append(NEW_LINE);
            sb.append("File " + info.files().bFile() + ", ");
            sb.append("Sheet: " + info.sheets().bSheetname() + ", ");
            sb.append(String.format("items (%s):" + NEW_LINE, info.collections().b().size()));
            sb.append(NEW_LINE);
            sb.append(new NewLineDecorator<T>(info.collections().b()));
            sb.append(NEW_LINE);
            sb.append(String.format("Difference (%s):" + NEW_LINE, info.collections().difference().size()));
            sb.append(NEW_LINE);
            sb.append(new NewLineDecorator<T>(info.collections().difference()));
            return sb.toString();
        }
    }

    private static class DiffResultImpl<T>
    implements DiffResult<T> {
        private final Collection<T> diff;
        private final boolean isIdentical;
        private final String report;

        public DiffResultImpl(Collection<T> diff, String report) {
            this.diff = diff;
            this.report = report;
            this.isIdentical = diff.size() == 0;
        }

        @Override
        public boolean isIdentical() {
            return this.isIdentical;
        }

        @Override
        public Collection<T> getDifference() {
            return this.diff;
        }

        @Override
        public String getReport() {
            return this.report;
        }
    }
}

