/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite.styles;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public final class CellStyles {
    private final String DEFAULT_DATE_FORMAT = "ddd mmm dd hh:mm:ss yyy";
    private final Workbook wb;
    private CellStyle boldStyle;
    private CellStyle dateStyle;

    public CellStyles(Workbook wb) {
        this.wb = wb;
        this.initStyles();
    }

    private void initStyles() {
        this.createBoldStyle();
        this.createDateFormatStyle();
    }

    private void createBoldStyle() {
        this.boldStyle = this.wb.createCellStyle();
        Font font = this.wb.createFont();
        font.setBoldweight((short)700);
        this.boldStyle.setFont(font);
    }

    private void createDateFormatStyle() {
        this.dateStyle = this.wb.createCellStyle();
        DataFormat df = this.wb.createDataFormat();
        this.dateStyle.setDataFormat(df.getFormat("ddd mmm dd hh:mm:ss yyy"));
    }

    public CellStyle getBoldStyle() {
        return this.boldStyle;
    }

    public CellStyle getDateStyle() {
        return this.dateStyle;
    }

    public CellStyle getCustomDataFormatStyle(String dataFormat) {
        CellStyle cellStyle = this.wb.createCellStyle();
        DataFormat df = this.wb.createDataFormat();
        cellStyle.setDataFormat(df.getFormat(dataFormat));
        return cellStyle;
    }

    public Workbook getWorkbook() {
        return this.wb;
    }
}

