/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite.reader;

import com.ebay.xcelite.reader.RowPostProcessor;
import com.ebay.xcelite.reader.SheetReader;
import com.ebay.xcelite.sheet.XceliteSheet;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;

public abstract class SheetReaderAbs<T>
implements SheetReader<T> {
    protected final XceliteSheet sheet;
    protected final List<RowPostProcessor<T>> rowPostProcessors;
    protected boolean skipHeader;

    public SheetReaderAbs(XceliteSheet sheet, boolean skipHeader) {
        this.sheet = sheet;
        this.skipHeader = skipHeader;
        this.rowPostProcessors = Lists.newArrayList();
    }

    protected Object readValueFromCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object cellValue = null;
        switch (cell.getCellType()) {
            case 4: {
                cellValue = cell.getBooleanCellValue();
                break;
            }
            case 0: {
                cellValue = cell.getNumericCellValue();
                break;
            }
            default: {
                cellValue = cell.getStringCellValue();
            }
        }
        return cellValue;
    }

    @Override
    public void skipHeaderRow(boolean skipHeaderRow) {
        this.skipHeader = skipHeaderRow;
    }

    @Override
    public XceliteSheet getSheet() {
        return this.sheet;
    }

    @Override
    public void addRowPostProcessor(RowPostProcessor<T> rowPostProcessor) {
        this.rowPostProcessors.add(rowPostProcessor);
    }

    @Override
    public void removeRowPostProcessor(RowPostProcessor<T> rowPostProcessor) {
        this.rowPostProcessors.remove(rowPostProcessor);
    }
}

