/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite.reader;

import com.ebay.xcelite.annotate.NoConverterClass;
import com.ebay.xcelite.annotations.AnyColumn;
import com.ebay.xcelite.column.Col;
import com.ebay.xcelite.column.ColumnsExtractor;
import com.ebay.xcelite.column.ColumnsMapper;
import com.ebay.xcelite.converters.ColumnValueConverter;
import com.ebay.xcelite.exceptions.XceliteException;
import com.ebay.xcelite.reader.RowPostProcessor;
import com.ebay.xcelite.reader.SheetReaderAbs;
import com.ebay.xcelite.sheet.XceliteSheet;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.reflections.ReflectionUtils;

public class BeanSheetReader<T>
extends SheetReaderAbs<T> {
    private final LinkedHashSet<Col> columns;
    private final Col anyColumn;
    private final ColumnsMapper mapper;
    private final Class<T> type;
    private LinkedHashSet<String> header;
    private Iterator<Row> rowIterator;

    public BeanSheetReader(XceliteSheet sheet, Class<T> type) {
        super(sheet, false);
        this.type = type;
        ColumnsExtractor extractor = new ColumnsExtractor(type);
        extractor.extract();
        this.columns = extractor.getColumns();
        this.anyColumn = extractor.getAnyColumn();
        this.mapper = new ColumnsMapper(this.columns);
    }

    @Override
    public Collection<T> read() {
        this.buildHeader();
        ArrayList data = Lists.newArrayList();
        try {
            while (this.rowIterator.hasNext()) {
                RowPostProcessor rowPostProcessor;
                Row row = this.rowIterator.next();
                if (this.isBlankRow(row)) continue;
                T object = this.type.newInstance();
                int i = 0;
                for (String columnName : this.header) {
                    Set fields;
                    Field field;
                    Cell cell = row.getCell(i, Row.RETURN_BLANK_AS_NULL);
                    Col col = this.mapper.getColumn(columnName);
                    if (col == null) {
                        if (this.anyColumn != null && !this.isColumnInIgnoreList(field = (Field)(fields = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)this.anyColumn.getFieldName())})).iterator().next(), columnName)) {
                            this.writeToAnyColumnField(field, object, cell, columnName);
                        }
                    } else {
                        fields = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)col.getFieldName())});
                        field = (Field)fields.iterator().next();
                        this.writeToField(field, object, cell, col);
                    }
                    ++i;
                }
                boolean keepObject = true;
                Iterator i$ = this.rowPostProcessors.iterator();
                while (i$.hasNext() && (keepObject = (rowPostProcessor = (RowPostProcessor)i$.next()).process(object))) {
                }
                if (!keepObject) continue;
                data.add(object);
            }
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
        return data;
    }

    private boolean isBlankRow(Row row) {
        Iterator cellIterator = row.cellIterator();
        boolean blankRow = true;
        while (cellIterator.hasNext()) {
            Object value = this.readValueFromCell((Cell)cellIterator.next());
            if (!blankRow || value == null || String.valueOf(value).isEmpty()) continue;
            blankRow = false;
        }
        return blankRow;
    }

    private boolean isColumnInIgnoreList(Field anyColumnField, String columnName) {
        AnyColumn annotation = anyColumnField.getAnnotation(AnyColumn.class);
        HashSet ignoreCols = Sets.newHashSet((Object[])annotation.ignoreCols());
        return ignoreCols.contains(columnName);
    }

    private void writeToAnyColumnField(Field field, T object, Cell cell, String columnName) {
        try {
            field.setAccessible(true);
            Object value = this.readValueFromCell(cell);
            if (value != null) {
                Map map;
                AnyColumn annotation = field.getAnnotation(AnyColumn.class);
                if (field.get(object) == null) {
                    map = annotation.as().newInstance();
                    field.set(object, map);
                }
                map = (Map)field.get(object);
                if (annotation.converter() != NoConverterClass.class) {
                    ColumnValueConverter<?, ?> converter = annotation.converter().newInstance();
                    value = converter.deserialize(value);
                }
                map.put(columnName, value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToField(Field field, T object, Cell cell, Col column) {
        try {
            Object cellValue = this.readValueFromCell(cell);
            if (cellValue != null) {
                if (column.getConverter() != null) {
                    ColumnValueConverter<?, ?> converter = column.getConverter().newInstance();
                    cellValue = converter.deserialize(cellValue);
                } else {
                    cellValue = this.convertToFieldType(cellValue, field.getType());
                }
            }
            field.setAccessible(true);
            field.set(object, cellValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Object convertToFieldType(Object cellValue, Class<?> fieldType) {
        String value = String.valueOf(cellValue);
        if (fieldType == Double.class || fieldType == Double.TYPE) {
            return Double.valueOf(value);
        }
        if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            return Double.valueOf(value).intValue();
        }
        if (fieldType == Short.class || fieldType == Short.TYPE) {
            return Double.valueOf(value).shortValue();
        }
        if (fieldType == Long.class || fieldType == Long.TYPE) {
            return Double.valueOf(value).longValue();
        }
        if (fieldType == Float.class || fieldType == Float.TYPE) {
            return Float.valueOf(Double.valueOf(value).floatValue());
        }
        if (fieldType == Character.class || fieldType == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (fieldType == Date.class) {
            return DateUtil.getJavaDate((double)Double.valueOf(value));
        }
        return value;
    }

    private void buildHeader() {
        this.header = Sets.newLinkedHashSet();
        this.rowIterator = this.sheet.getNativeSheet().rowIterator();
        Row row = this.rowIterator.next();
        if (row == null) {
            throw new XceliteException("First row in sheet is empty. First row must contain header");
        }
        Iterator itr = row.cellIterator();
        while (itr.hasNext()) {
            Cell cell = (Cell)itr.next();
            this.header.add(cell.getStringCellValue());
        }
    }
}

