/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite.column;

import com.ebay.xcelite.annotate.NoConverterClass;
import com.ebay.xcelite.annotations.AnyColumn;
import com.ebay.xcelite.annotations.Column;
import com.ebay.xcelite.annotations.Row;
import com.ebay.xcelite.column.Col;
import com.ebay.xcelite.exceptions.XceliteException;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.reflections.ReflectionUtils;

public class ColumnsExtractor {
    private final Class<?> type;
    private Set<Col> columns;
    private Col anyColumn;
    private Set<Col> colsOrdering;

    public ColumnsExtractor(Class<?> type) {
        this.type = type;
        this.columns = Sets.newLinkedHashSet();
        this.columnsOrdering();
    }

    private void columnsOrdering() {
        Row rowAnnotation = this.type.getAnnotation(Row.class);
        if (rowAnnotation == null || rowAnnotation.colsOrder() == null || rowAnnotation.colsOrder().length == 0) {
            return;
        }
        this.colsOrdering = Sets.newLinkedHashSet();
        for (String column : rowAnnotation.colsOrder()) {
            this.colsOrdering.add(new Col(column));
        }
    }

    public void extract() {
        Set columnFields = ReflectionUtils.getAllFields(this.type, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Column.class)});
        for (Field columnField : columnFields) {
            Column annotation = columnField.getAnnotation(Column.class);
            Col col = null;
            col = annotation.name().isEmpty() ? new Col(columnField.getName(), columnField.getName()) : new Col(annotation.name(), columnField.getName());
            if (annotation.ignoreType()) {
                col.setType(String.class);
            } else {
                col.setType(columnField.getType());
            }
            if (!annotation.dataFormat().isEmpty()) {
                col.setDataFormat(annotation.dataFormat());
            }
            if (annotation.converter() != NoConverterClass.class) {
                col.setConverter(annotation.converter());
            }
            this.columns.add(col);
        }
        if (this.colsOrdering != null) {
            this.orderColumns();
        }
        this.extractAnyColumn();
    }

    private void extractAnyColumn() {
        Set anyColumnFields = ReflectionUtils.getAllFields(this.type, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(AnyColumn.class)});
        if (anyColumnFields.size() > 0) {
            if (anyColumnFields.size() > 1) {
                throw new XceliteException("Multiple AnyColumn fields are not allowed");
            }
            Field anyColumnField = (Field)anyColumnFields.iterator().next();
            if (!anyColumnField.getType().isAssignableFrom(Map.class)) {
                throw new XceliteException(String.format("AnyColumn field \"%s\" should be of type Map.class or assignable from Map.class", anyColumnField.getName()));
            }
            this.anyColumn = new Col(anyColumnField.getName(), anyColumnField.getName());
            this.anyColumn.setAnyColumn(true);
            AnyColumn annotation = anyColumnField.getAnnotation(AnyColumn.class);
            this.anyColumn.setType(annotation.as());
            if (annotation.converter() != NoConverterClass.class) {
                this.anyColumn.setConverter(annotation.converter());
            }
        }
    }

    private void orderColumns() {
        HashMap map = Maps.newHashMap();
        for (Col col : this.columns) {
            map.put(col.getName(), col);
        }
        for (Col col : this.colsOrdering) {
            if (this.columns.contains(col)) {
                Col column = (Col)map.get(col.getName());
                column.copyTo(col);
                continue;
            }
            throw new RuntimeException(String.format("Unrecognized column \"%s\" in Row columns ordering", col.getName()));
        }
        if (this.colsOrdering.size() != this.columns.size()) {
            throw new RuntimeException(String.format("Not all columns are specified in Row columns ordering", new Object[0]));
        }
        this.columns = this.colsOrdering;
    }

    public LinkedHashSet<Col> getColumns() {
        return (LinkedHashSet)this.columns;
    }

    public Col getAnyColumn() {
        return this.anyColumn;
    }
}

