/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.xcelite;

import com.ebay.xcelite.exceptions.XceliteException;
import com.ebay.xcelite.sheet.XceliteSheet;
import com.ebay.xcelite.sheet.XceliteSheetImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Xcelite {
    private final Workbook workbook;
    private File file;

    public Xcelite() {
        this.workbook = new XSSFWorkbook();
    }

    public Xcelite(File file) {
        try {
            this.file = file;
            this.workbook = new XSSFWorkbook((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XceliteSheet createSheet() {
        return new XceliteSheetImpl(this.workbook.createSheet(), this.file);
    }

    public XceliteSheet createSheet(String name) {
        return new XceliteSheetImpl(this.workbook.createSheet(name), this.file);
    }

    public XceliteSheet getSheet(int sheetIndex) {
        Sheet sheet = this.workbook.getSheetAt(sheetIndex);
        if (sheet == null) {
            throw new XceliteException(String.format("Could not find sheet at index %s", sheetIndex));
        }
        return new XceliteSheetImpl(sheet, this.file);
    }

    public XceliteSheet getSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new XceliteException(String.format("Could not find sheet named \"%s\"", sheetName));
        }
        return new XceliteSheetImpl(sheet, this.file);
    }

    public void write() {
        if (this.file == null) {
            throw new XceliteException("No file given in Xcelite object construction. Consider using method write(file)");
        }
        this.write(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file, false);
            this.workbook.write((OutputStream)out);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.workbook.write((OutputStream)baos);
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    new RuntimeException(e);
                }
            }
        }
        return baos.toByteArray();
    }
}

