/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsChannelFactory;
import com.eatthepath.pushy.apns.ApnsChannelPool;
import com.eatthepath.pushy.apns.ApnsChannelPoolMetricsListener;
import com.eatthepath.pushy.apns.ApnsClientMetricsListener;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.PushNotificationResponse;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.auth.AuthenticationTokenProvider;
import com.eatthepath.pushy.apns.proxy.ProxyHandlerFactory;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationFuture;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsClient {
    private final EventLoopGroup eventLoopGroup;
    private final boolean shouldShutDownEventLoopGroup;
    private final AuthenticationTokenProvider authenticationTokenProvider;
    private final ApnsChannelPool channelPool;
    private final ApnsClientMetricsListener metricsListener;
    private final AtomicLong nextNotificationId = new AtomicLong(0L);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private static final IllegalStateException CLIENT_CLOSED_EXCEPTION = new IllegalStateException("Client has been closed and can no longer send push notifications.");
    private static final Logger log = LoggerFactory.getLogger(ApnsClient.class);

    protected ApnsClient(InetSocketAddress apnsServerAddress, SslContext sslContext, boolean hostnameVerificationEnabled, ApnsSigningKey signingKey, Duration tokenExpiration, ProxyHandlerFactory proxyHandlerFactory, Duration connectTimeout, Duration idlePingInterval, Duration gracefulShutdownTimeout, int concurrentConnections, ApnsClientMetricsListener metricsListener, Http2FrameLogger frameLogger, EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup != null) {
            this.eventLoopGroup = eventLoopGroup;
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.eventLoopGroup = new NioEventLoopGroup(1);
            this.shouldShutDownEventLoopGroup = true;
        }
        this.authenticationTokenProvider = signingKey != null ? new AuthenticationTokenProvider(signingKey, tokenExpiration, (ScheduledExecutorService)this.eventLoopGroup) : null;
        this.metricsListener = metricsListener != null ? metricsListener : new NoopApnsClientMetricsListener();
        ApnsChannelFactory channelFactory = new ApnsChannelFactory(sslContext, hostnameVerificationEnabled, this.authenticationTokenProvider, proxyHandlerFactory, connectTimeout, idlePingInterval, gracefulShutdownTimeout, frameLogger, apnsServerAddress, this.eventLoopGroup);
        ApnsChannelPoolMetricsListener channelPoolMetricsListener = new ApnsChannelPoolMetricsListener(){

            @Override
            public void handleConnectionAdded() {
                ApnsClient.this.metricsListener.handleConnectionAdded(ApnsClient.this);
            }

            @Override
            public void handleConnectionRemoved() {
                ApnsClient.this.metricsListener.handleConnectionRemoved(ApnsClient.this);
            }

            @Override
            public void handleConnectionCreationFailed() {
                ApnsClient.this.metricsListener.handleConnectionCreationFailed(ApnsClient.this);
            }
        };
        this.channelPool = new ApnsChannelPool(channelFactory, concurrentConnections, (OrderedEventExecutor)this.eventLoopGroup.next(), channelPoolMetricsListener);
    }

    public <T extends ApnsPushNotification> PushNotificationFuture<T, PushNotificationResponse<T>> sendNotification(T notification) {
        PushNotificationFuture responseFuture = new PushNotificationFuture(notification);
        if (!this.isClosed.get()) {
            long notificationId = this.nextNotificationId.getAndIncrement();
            this.channelPool.acquire().addListener(acquireFuture -> {
                if (acquireFuture.isSuccess()) {
                    Channel channel = (Channel)acquireFuture.getNow();
                    channel.writeAndFlush((Object)responseFuture).addListener(future -> {
                        if (future.isSuccess()) {
                            this.metricsListener.handleNotificationSent(this, notificationId);
                        }
                    });
                    this.channelPool.release(channel);
                } else {
                    responseFuture.completeExceptionally(acquireFuture.cause());
                }
            });
            responseFuture.whenComplete((response, cause) -> {
                if (response != null) {
                    if (response.isAccepted()) {
                        this.metricsListener.handleNotificationAccepted(this, notificationId);
                    } else {
                        this.metricsListener.handleNotificationRejected(this, notificationId);
                    }
                } else {
                    this.metricsListener.handleWriteFailure(this, notificationId);
                }
            });
        } else {
            responseFuture.completeExceptionally(CLIENT_CLOSED_EXCEPTION);
        }
        return responseFuture;
    }

    AuthenticationTokenProvider getAuthenticationTokenProvider() {
        return this.authenticationTokenProvider;
    }

    public CompletableFuture<Void> close() {
        CompletableFuture<Object> closeFuture;
        log.info("Shutting down.");
        if (this.isClosed.compareAndSet(false, true)) {
            if (this.authenticationTokenProvider != null) {
                this.authenticationTokenProvider.close();
            }
            closeFuture = new CompletableFuture();
            this.channelPool.close().addListener(closePoolFuture -> {
                if (this.shouldShutDownEventLoopGroup) {
                    this.eventLoopGroup.shutdownGracefully().addListener(future -> closeFuture.complete(null));
                } else {
                    closeFuture.complete(null);
                }
            });
        } else {
            closeFuture = CompletableFuture.completedFuture(null);
        }
        return closeFuture;
    }

    private static class NoopApnsClientMetricsListener
    implements ApnsClientMetricsListener {
        private NoopApnsClientMetricsListener() {
        }

        @Override
        public void handleWriteFailure(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationSent(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationAccepted(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationRejected(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleConnectionAdded(ApnsClient apnsClient) {
        }

        @Override
        public void handleConnectionRemoved(ApnsClient apnsClient) {
        }

        @Override
        public void handleConnectionCreationFailed(ApnsClient apnsClient) {
        }
    }
}

