/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsChannelPoolMetricsListener;
import com.eatthepath.pushy.apns.PooledObjectFactory;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApnsChannelPool {
    private final PooledObjectFactory<Channel> channelFactory;
    private final OrderedEventExecutor executor;
    private final int capacity;
    private final ApnsChannelPoolMetricsListener metricsListener;
    private final ChannelGroup allChannels;
    private final Queue<Channel> idleChannels = new ArrayDeque<Channel>();
    private final Set<Future<Channel>> pendingCreateChannelFutures = new HashSet<Future<Channel>>();
    private final Queue<Promise<Channel>> pendingAcquisitionPromises = new ArrayDeque<Promise<Channel>>();
    private boolean isClosed = false;
    private static final Exception POOL_CLOSED_EXCEPTION = new IllegalStateException("Channel pool has closed and no more channels may be acquired.");
    private static final Logger log = LoggerFactory.getLogger(ApnsChannelPool.class);

    ApnsChannelPool(PooledObjectFactory<Channel> channelFactory, int capacity, OrderedEventExecutor executor, ApnsChannelPoolMetricsListener metricsListener) {
        this.channelFactory = channelFactory;
        this.capacity = capacity;
        this.executor = executor;
        this.metricsListener = metricsListener != null ? metricsListener : new NoopChannelPoolMetricsListener();
        this.allChannels = new DefaultChannelGroup((EventExecutor)this.executor, true);
    }

    Future<Channel> acquire() {
        DefaultPromise acquirePromise = new DefaultPromise((EventExecutor)this.executor);
        if (this.executor.inEventLoop()) {
            this.acquireWithinEventExecutor((Promise<Channel>)acquirePromise);
        } else {
            this.executor.submit(() -> this.lambda$acquire$0((Promise)acquirePromise)).addListener(arg_0 -> ApnsChannelPool.lambda$acquire$1((Promise)acquirePromise, arg_0));
        }
        return acquirePromise;
    }

    private void acquireWithinEventExecutor(Promise<Channel> acquirePromise) {
        assert (this.executor.inEventLoop());
        if (!this.isClosed) {
            if (this.allChannels.size() + this.pendingCreateChannelFutures.size() < this.capacity) {
                Future<Channel> createChannelFuture = this.channelFactory.create((Promise<Channel>)this.executor.newPromise());
                this.pendingCreateChannelFutures.add(createChannelFuture);
                createChannelFuture.addListener(future -> {
                    this.pendingCreateChannelFutures.remove(createChannelFuture);
                    if (future.isSuccess()) {
                        Channel channel = (Channel)future.getNow();
                        this.allChannels.add((Object)channel);
                        this.metricsListener.handleConnectionAdded();
                        acquirePromise.trySuccess((Object)channel);
                    } else {
                        this.metricsListener.handleConnectionCreationFailed();
                        acquirePromise.tryFailure(future.cause());
                        this.handleNextAcquisition();
                    }
                });
            } else {
                Channel channelFromIdlePool = this.idleChannels.poll();
                if (channelFromIdlePool != null) {
                    if (channelFromIdlePool.isActive()) {
                        acquirePromise.trySuccess((Object)channelFromIdlePool);
                    } else {
                        this.discardChannel(channelFromIdlePool);
                        this.acquireWithinEventExecutor(acquirePromise);
                    }
                } else {
                    this.pendingAcquisitionPromises.add(acquirePromise);
                }
            }
        } else {
            acquirePromise.tryFailure((Throwable)POOL_CLOSED_EXCEPTION);
        }
    }

    void release(Channel channel) {
        if (this.executor.inEventLoop()) {
            this.releaseWithinEventExecutor(channel);
        } else {
            this.executor.submit(() -> this.releaseWithinEventExecutor(channel));
        }
    }

    private void releaseWithinEventExecutor(Channel channel) {
        assert (this.executor.inEventLoop());
        this.idleChannels.add(channel);
        this.handleNextAcquisition();
    }

    private void handleNextAcquisition() {
        assert (this.executor.inEventLoop());
        if (!this.pendingAcquisitionPromises.isEmpty()) {
            this.acquireWithinEventExecutor(this.pendingAcquisitionPromises.poll());
        }
    }

    private void discardChannel(Channel channel) {
        assert (this.executor.inEventLoop());
        this.idleChannels.remove(channel);
        this.allChannels.remove((Object)channel);
        this.metricsListener.handleConnectionRemoved();
        this.channelFactory.destroy(channel, (Promise<Void>)this.executor.newPromise()).addListener(destroyFuture -> {
            if (!destroyFuture.isSuccess()) {
                log.warn("Failed to destroy channel.", destroyFuture.cause());
            }
        });
    }

    public Future<Void> close() {
        DefaultPromise closePromise = new DefaultPromise((EventExecutor)this.executor);
        this.allChannels.close().addListener(arg_0 -> this.lambda$close$6((Promise)closePromise, arg_0));
        return closePromise;
    }

    private /* synthetic */ void lambda$close$6(Promise closePromise, Future allCloseFuture) throws Exception {
        this.isClosed = true;
        DefaultPromise waitForPendingCreateChannelFuturesPromise = new DefaultPromise((EventExecutor)this.executor);
        PromiseCombiner combiner = new PromiseCombiner((EventExecutor)this.executor);
        for (Future<Channel> f : this.pendingCreateChannelFutures) {
            combiner.add(f);
        }
        combiner.finish((Promise)waitForPendingCreateChannelFuturesPromise);
        waitForPendingCreateChannelFuturesPromise.addListener(pendingChannelsFuture -> {
            if (this.channelFactory instanceof Closeable) {
                ((Closeable)((Object)this.channelFactory)).close();
            }
            for (Promise promise : this.pendingAcquisitionPromises) {
                promise.tryFailure((Throwable)POOL_CLOSED_EXCEPTION);
            }
            closePromise.setSuccess(null);
        });
    }

    private static /* synthetic */ void lambda$acquire$1(Promise acquirePromise, Future future) throws Exception {
        if (!future.isSuccess()) {
            acquirePromise.tryFailure(future.cause());
        }
    }

    private /* synthetic */ void lambda$acquire$0(Promise acquirePromise) {
        this.acquireWithinEventExecutor((Promise<Channel>)acquirePromise);
    }

    private static class NoopChannelPoolMetricsListener
    implements ApnsChannelPoolMetricsListener {
        private NoopChannelPoolMetricsListener() {
        }

        @Override
        public void handleConnectionAdded() {
        }

        @Override
        public void handleConnectionRemoved() {
        }

        @Override
        public void handleConnectionCreationFailed() {
        }
    }
}

