/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.util.jackson;

import com.eatthepath.pushy.apns.util.ApnsPayloadBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;

public class JacksonApnsPayloadBuilder
extends ApnsPayloadBuilder {
    private final ObjectMapper objectMapper;
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();

    public JacksonApnsPayloadBuilder() {
        this(DEFAULT_OBJECT_MAPPER);
    }

    public JacksonApnsPayloadBuilder(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public String build() {
        try {
            return this.objectMapper.writeValueAsString((Object)this.buildPayloadMap());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String buildMdmPayload(String pushMagicValue) {
        try {
            return this.objectMapper.writeValueAsString((Object)this.buildMdmPayloadMap(pushMagicValue));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

