/*
 * Decompiled with CFR 0.152.
 */
package com.easylibs.http.volley;

import android.content.Context;
import com.android.volley.Cache;
import com.android.volley.Network;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.DiskBasedCache;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.HurlStack;
import com.android.volley.toolbox.RequestFuture;
import com.easylibs.http.EasyHttpExecutor;
import com.easylibs.http.EasyHttpRequest;
import com.easylibs.http.EasyHttpResponse;
import com.easylibs.http.volley.EasyJsonListener;
import com.easylibs.http.volley.EasyJsonRequest;
import com.easylibs.http.volley.EasyRetryPolicy;
import com.easylibs.http.volley.EasyStringListener;
import com.easylibs.http.volley.EasyStringRequest;
import java.io.File;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;

class EasyHttpExecutorVolleyImpl
implements EasyHttpExecutor {
    private static final String LOG_TAG = EasyHttpExecutorVolleyImpl.class.getSimpleName();
    private String mDefaultRequestTag;
    private RequestQueue mRequestQueue;

    private EasyHttpExecutorVolleyImpl(Context context) {
        this.mDefaultRequestTag = context.getPackageName();
        File file = new File(context.getCacheDir(), "networkCache");
        BasicNetwork basicNetwork = new BasicNetwork((HttpStack)new HurlStack());
        this.mRequestQueue = new RequestQueue((Cache)new DiskBasedCache(file), (Network)basicNetwork);
        this.mRequestQueue.start();
    }

    public <T> void executeAsync(EasyHttpRequest<T> easyHttpRequest) {
        Object object;
        int n = this.getVolleyHttpMethod(easyHttpRequest.getHttpMethod());
        if (easyHttpRequest.getResponseType() == String.class) {
            EasyStringListener easyStringListener = new EasyStringListener(easyHttpRequest);
            object = new EasyStringRequest(n, easyHttpRequest.getUrl(), easyStringListener, easyHttpRequest.getHeaders(), easyHttpRequest.getPostParams());
        } else {
            EasyJsonListener<T> easyJsonListener = new EasyJsonListener<T>(easyHttpRequest);
            object = new EasyJsonRequest<T>(n, easyHttpRequest, easyJsonListener, easyJsonListener);
        }
        object.setRetryPolicy((RetryPolicy)new EasyRetryPolicy(easyHttpRequest));
        object.setTag(this.mDefaultRequestTag);
        this.mRequestQueue.add(object);
    }

    private int getVolleyHttpMethod(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return -1;
    }

    public <T> EasyHttpResponse<T> executeSync(EasyHttpRequest<T> easyHttpRequest) {
        if (easyHttpRequest.getResponseType() == InputStream.class) {
            return this.getStreamResponse(easyHttpRequest);
        }
        int n = this.getVolleyHttpMethod(easyHttpRequest.getHttpMethod());
        RequestFuture requestFuture = RequestFuture.newFuture();
        EasyJsonRequest<T> easyJsonRequest = new EasyJsonRequest<T>(n, easyHttpRequest, requestFuture, (Response.ErrorListener)requestFuture);
        this.mRequestQueue.add(easyJsonRequest);
        try {
            return (EasyHttpResponse)requestFuture.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EasyHttpResponse easyHttpResponse = new EasyHttpResponse();
            easyHttpResponse.setStatusCode(500);
            easyHttpResponse.setException(exception);
            return easyHttpResponse;
        }
    }

    public synchronized void cancelPendingRequests(Object object) {
        if (object == null) {
            object = this.mDefaultRequestTag;
        }
        if (this.mRequestQueue != null) {
            this.mRequestQueue.cancelAll(object);
        }
    }

    private EasyHttpResponse getStreamResponse(EasyHttpRequest easyHttpRequest) {
        EasyHttpResponse easyHttpResponse = new EasyHttpResponse();
        easyHttpResponse.setEasyHttpRequest(easyHttpRequest);
        HttpResponse httpResponse = null;
        try {
            HttpPost httpPost;
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            switch (easyHttpRequest.getHttpMethod()) {
                case 2: {
                    httpPost = new HttpPost(easyHttpRequest.getUrl());
                    break;
                }
                default: {
                    httpPost = new HttpGet(easyHttpRequest.getUrl());
                }
            }
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            easyHttpResponse.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            BufferedHttpEntity bufferedHttpEntity = new BufferedHttpEntity(httpResponse.getEntity());
            easyHttpResponse.setData((Object)bufferedHttpEntity.getContent());
        }
        catch (Exception exception) {
            easyHttpResponse.setException(exception);
            exception.printStackTrace();
        }
        return easyHttpResponse;
    }
}

