/*
 * Decompiled with CFR 0.152.
 */
package com.eastwood.common.adapter.auto;

import android.content.Context;
import android.content.res.TypedArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.eastwood.common.adapter.BaseAdapterHelper;
import com.eastwood.common.adapter.BaseQuickAdapter;
import com.eastwood.common.adapter.R;
import com.eastwood.common.adapter.ViewHelper;
import com.eastwood.common.adapter.auto.OnAutoLoadListener;
import java.util.List;

public abstract class BaseAutoAdapter<T>
extends BaseQuickAdapter<T, BaseAdapterHelper> {
    protected boolean autoLoadEnable;
    protected boolean manualLoad;
    protected boolean loadError;
    protected boolean loadEnd;
    protected boolean loading;
    private int loadingLayoutResId;
    private int manualLayoutResId;
    private int loadEndLayoutResId;
    private int loadErrorLayoutResId;
    protected boolean alwaysShowHeader = false;
    protected OnAutoLoadListener mOnAutoLoadListener;
    protected View.OnClickListener mOnLastItemClickListener;
    protected View.OnClickListener mEmptyClick = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };

    public BaseAutoAdapter() {
    }

    public BaseAutoAdapter(Context context, int layoutResId) {
        super(context, layoutResId, null);
    }

    public BaseAutoAdapter(Context context, int layoutResId, List<T> data) {
        super(context, layoutResId, data);
    }

    protected abstract int getBodyCount();

    @Override
    public int getCount() {
        return this.getBodyCount() + (this.autoLoadEnable ? 1 : 0);
    }

    @Override
    public T getItem(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return (T)this.data.get(position);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.getItemViewType(position) == 0) {
            ViewHelper helper = this.getAdapterHelper(position, convertView, parent);
            T item = this.getItem(position);
            this.convert(position, helper, item);
            return helper.getView();
        }
        return this.createAutoLoadView(convertView, parent);
    }

    protected View createAutoLoadView(View convertView, ViewGroup parent) {
        Context context = parent.getContext();
        if (this.loadingLayoutResId == 0) {
            this.loadingLayoutResId = this.resolve(context, R.attr.auto_adapter_loading_layout, R.layout.default_loading_layout);
        }
        if (this.manualLayoutResId == 0) {
            this.manualLayoutResId = this.resolve(context, R.attr.auto_adapter_manual_layout, R.layout.default_manual_layout);
        }
        if (this.loadEndLayoutResId == 0) {
            this.loadEndLayoutResId = this.resolve(context, R.attr.auto_adapter_end_layout, R.layout.default_end_layout);
        }
        if (this.loadErrorLayoutResId == 0) {
            this.loadErrorLayoutResId = this.resolve(context, R.attr.auto_adapter_error_layout, R.layout.default_error_layout);
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        if (this.loadError) {
            convertView = layoutInflater.inflate(this.loadErrorLayoutResId, parent, false);
            convertView.setOnClickListener(this.mOnLastItemClickListener);
        } else if (this.loadEnd) {
            convertView = layoutInflater.inflate(this.loadEndLayoutResId, parent, false);
            convertView.setOnClickListener(this.mEmptyClick);
        } else if (!this.manualLoad || this.loading) {
            if (!this.loading && this.mOnAutoLoadListener != null) {
                this.mOnAutoLoadListener.onLoading();
            }
            convertView = layoutInflater.inflate(this.loadingLayoutResId, parent, false);
            convertView.setOnClickListener(this.mEmptyClick);
        } else {
            convertView = layoutInflater.inflate(this.manualLayoutResId, parent, false);
            convertView.setOnClickListener(this.mOnLastItemClickListener);
        }
        return convertView;
    }

    public void setAutoLoadEnable(boolean enable) {
        if (enable == this.autoLoadEnable) {
            return;
        }
        this.autoLoadEnable = enable;
        this.notifyDataSetChanged();
    }

    public boolean isAutoLoadEnable() {
        return this.autoLoadEnable;
    }

    @Deprecated
    public void setAutoLoadUsable(boolean usable) {
        this.setAutoLoadEnable(usable);
    }

    @Deprecated
    public boolean isAutoLoadUsable() {
        return this.isAutoLoadEnable();
    }

    public boolean isManualLoad() {
        return this.manualLoad;
    }

    public void setManualLoad(boolean manualLoad) {
        if (manualLoad == this.manualLoad) {
            return;
        }
        this.manualLoad = manualLoad;
        this.notifyDataSetChanged();
    }

    public boolean isLoadError() {
        return this.loadError;
    }

    public void setLoadError(boolean loadError) {
        if (loadError == this.loadError) {
            return;
        }
        this.loadError = loadError;
        this.notifyDataSetChanged();
    }

    public boolean isLoadEnd() {
        return this.loadEnd;
    }

    public void setLoadEnd(boolean loadEnd) {
        if (loadEnd == this.loadEnd) {
            return;
        }
        this.loadEnd = loadEnd;
        this.notifyDataSetChanged();
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        if (loading == this.loading) {
            return;
        }
        this.loading = loading;
        this.notifyDataSetChanged();
    }

    public void setLoadingLayoutResId(int resId) {
        this.loadingLayoutResId = resId;
    }

    public int getLoadingLayoutResId() {
        return this.loadingLayoutResId;
    }

    public void setManualLayoutResId(int resId) {
        this.manualLayoutResId = resId;
    }

    public int getManualLayoutResId() {
        return this.manualLayoutResId;
    }

    public int getLoadEndLayoutResId() {
        return this.loadEndLayoutResId;
    }

    public void setLoadEndLayoutResId(int loadEndLayoutResId) {
        this.loadEndLayoutResId = loadEndLayoutResId;
    }

    public int getLoadErrorLayoutResId() {
        return this.loadErrorLayoutResId;
    }

    public void setLoadErrorLayoutResId(int loadErrorLayoutResId) {
        this.loadErrorLayoutResId = loadErrorLayoutResId;
    }

    public void setOnAutoLoadListener(OnAutoLoadListener listener) {
        this.mOnAutoLoadListener = listener;
    }

    public void setOnLastItemClickListener(View.OnClickListener listener) {
        this.mOnLastItemClickListener = listener;
    }

    public void setAlwaysShowHeader(boolean alwaysShowHeader) {
        this.alwaysShowHeader = alwaysShowHeader;
    }

    public boolean isAlwaysShowHeader() {
        return this.alwaysShowHeader;
    }

    public boolean isEmpty() {
        if (this.alwaysShowHeader) {
            return false;
        }
        return super.isEmpty();
    }

    public void onAutoLoadError() {
        this.loadError = true;
        this.notifyDataSetChanged();
    }

    public void onAutoLoadStart() {
        this.manualLoad = false;
        this.loading = false;
        this.loadError = false;
        this.loadEnd = false;
        this.notifyDataSetChanged();
    }

    public void onAutoLoadFinished(boolean loadEnd) {
        this.loading = false;
        this.loadError = false;
        this.loadEnd = loadEnd;
        this.notifyDataSetChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolve(Context context, int attr2, int defValue) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getResourceId(0, defValue);
            return n;
        }
        finally {
            a.recycle();
        }
    }
}

