/*
 * Decompiled with CFR 0.152.
 */
package com.eastwood.common.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.eastwood.common.adapter.ViewHelper;

public class RecyclerAdapterHelper
extends RecyclerView.ViewHolder
implements ViewHelper<RecyclerAdapterHelper> {
    private Context context;
    private final SparseArray<View> views;
    private View convertView;

    public RecyclerAdapterHelper(Context context, View itemView) {
        super(itemView);
        this.context = context;
        this.views = new SparseArray();
        this.convertView = itemView;
        this.convertView.setTag((Object)this);
    }

    @Override
    public View getView() {
        return this.convertView;
    }

    private <T extends View> T retrieveView(int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.convertView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }

    @Override
    public <T extends View> T getView(int viewId) {
        return this.retrieveView(viewId);
    }

    @Override
    public RecyclerAdapterHelper setText(int viewId, String value) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText((CharSequence)value);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setText(int viewId, CharSequence value) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText(value);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setText(int viewId, int valueId) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText(valueId);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setImageResource(int viewId, int imageResId) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setBackgroundColor(int viewId, int color) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.context.getResources().getColor(textColorRes));
        return this;
    }

    @Override
    public RecyclerAdapterHelper setImageDrawable(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.retrieveView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.retrieveView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    @Override
    public RecyclerAdapterHelper setVisibility(int viewId, int visibility) {
        Object view = this.retrieveView(viewId);
        view.setVisibility(visibility);
        return this;
    }

    @Override
    public RecyclerAdapterHelper linkify(int viewId) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.retrieveView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    @Override
    public RecyclerAdapterHelper setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setProgress(progress);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setRating(rating);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setOnTouchListener(int viewId, View.OnTouchListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setOnLongClickListener(int viewId, View.OnLongClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setOnItemClickListener(int viewId, AdapterView.OnItemClickListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemClickListener(listener);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setOnItemLongClickListener(int viewId, AdapterView.OnItemLongClickListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemLongClickListener(listener);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setOnItemSelectedClickListener(int viewId, AdapterView.OnItemSelectedListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemSelectedListener(listener);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setTag(int viewId, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(tag);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setTag(int viewId, int key, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(key, tag);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.retrieveView(viewId);
        view.setChecked(checked);
        return this;
    }

    @Override
    public RecyclerAdapterHelper setAdapter(int viewId, Adapter adapter) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setAdapter(adapter);
        return this;
    }
}

