/*
 * Decompiled with CFR 0.152.
 */
package com.eastwood.common.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.eastwood.common.adapter.RecyclerAdapterHelper;
import com.eastwood.common.adapter.ViewHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickRecyclerAdapter<T, VH extends RecyclerAdapterHelper>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected final Context context;
    protected final List<T> data;
    protected LayoutInflater mLayoutInflater;

    protected BaseQuickRecyclerAdapter() {
        this(null, null);
    }

    protected BaseQuickRecyclerAdapter(Context context) {
        this(context, null);
    }

    protected BaseQuickRecyclerAdapter(Context context, List<T> data) {
        this.data = data == null ? new ArrayList() : data;
        this.context = context;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public T getItem(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    public List<T> getData() {
        return this.data;
    }

    public int getItemViewType(int position) {
        return this.getItemType(position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.getItemView(this.getItemLayoutId(viewType), parent);
        return this.createViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        this.convert(position, (ViewHelper)viewHolder, this.data.get(position));
    }

    protected View getItemView(int layoutResId, ViewGroup parent) {
        if (this.mLayoutInflater == null) {
            this.mLayoutInflater = LayoutInflater.from((Context)parent.getContext());
        }
        return this.mLayoutInflater.inflate(layoutResId, parent, false);
    }

    protected RecyclerAdapterHelper createViewHolder(View view) {
        return new RecyclerAdapterHelper(this.context, view);
    }

    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    public void addAll(List<T> elem) {
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    public void set(T oldElem, T newElem) {
        this.set(this.data.indexOf(oldElem), newElem);
    }

    public void set(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
    }

    public void remove(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
    }

    public void replaceAll(List<T> elem) {
        this.data.clear();
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    public void clear() {
        this.data.clear();
        this.notifyDataSetChanged();
    }

    protected abstract void convert(int var1, ViewHelper var2, T var3);

    protected abstract int getItemType(int var1);

    protected abstract int getItemLayoutId(int var1);
}

