/*
 * Decompiled with CFR 0.152.
 */
package com.eastwood.common.adapter.auto;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.eastwood.common.adapter.BaseQuickRecyclerAdapter;
import com.eastwood.common.adapter.R;
import com.eastwood.common.adapter.RecyclerAdapterHelper;
import com.eastwood.common.adapter.auto.OnAutoLoadListener;
import java.util.List;

public abstract class BaseAutoRecyclerAdapter<T, VH extends RecyclerAdapterHelper>
extends BaseQuickRecyclerAdapter<T, VH> {
    private LayoutInflater mLayoutInflater;
    private boolean autoLoadUsable;
    private boolean manualLoad;
    private boolean loadError;
    private boolean loadEnd;
    private boolean loading;
    private int loadingLayoutResId;
    private int manualLayoutResId;
    private int loadEndLayoutResId;
    private int loadErrorLayoutResId;
    private OnAutoLoadListener mOnAutoLoadListener;
    private View.OnClickListener mOnLastItemClickListener;
    private View.OnClickListener mEmptyClick = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };
    private static final int AUTO_LOAD_VIEW_TYPE = -3001;
    private static final int CLICKABLE_VIEW_TYPE = -3002;
    private static final int ERROR_VIEW_TYPE = -3003;
    private static final int END_VIEW_TYPE = -3004;

    protected BaseAutoRecyclerAdapter() {
    }

    protected BaseAutoRecyclerAdapter(Context context) {
        super(context);
    }

    protected BaseAutoRecyclerAdapter(Context context, List<T> data) {
        super(context, data);
    }

    protected abstract int getBodyCount();

    protected abstract int getBodyItemViewType(int var1);

    protected abstract void onBodyBindViewHolder(RecyclerView.ViewHolder var1, int var2);

    protected View createAutoLoadView(ViewGroup parent) {
        this.initLayout(parent.getContext());
        View autoLoadView = null;
        if (this.loadError) {
            autoLoadView = this.getItemView(this.loadErrorLayoutResId, parent);
            autoLoadView.setOnClickListener(this.mOnLastItemClickListener);
        } else if (this.loadEnd) {
            autoLoadView = this.getItemView(this.loadEndLayoutResId, parent);
            autoLoadView.setOnClickListener(this.mOnLastItemClickListener);
        } else if (!this.manualLoad || this.loading) {
            autoLoadView = this.getItemView(this.loadingLayoutResId, parent);
            autoLoadView.setOnClickListener(this.mEmptyClick);
        } else {
            autoLoadView = this.getItemView(this.manualLayoutResId, parent);
            autoLoadView.setOnClickListener(this.mOnLastItemClickListener);
        }
        return autoLoadView;
    }

    private void initLayout(Context context) {
        if (this.loadingLayoutResId == 0) {
            this.loadingLayoutResId = this.resolve(context, R.attr.auto_adapter_loading_layout, R.layout.default_loading_layout);
        }
        if (this.manualLayoutResId == 0) {
            this.manualLayoutResId = this.resolve(context, R.attr.auto_adapter_manual_layout, R.layout.default_manual_layout);
        }
        if (this.loadEndLayoutResId == 0) {
            this.loadEndLayoutResId = this.resolve(context, R.attr.auto_adapter_end_layout, R.layout.default_end_layout);
        }
        if (this.loadErrorLayoutResId == 0) {
            this.loadErrorLayoutResId = this.resolve(context, R.attr.auto_adapter_error_layout, R.layout.default_error_layout);
        }
    }

    @Override
    public int getItemCount() {
        super.getItemCount();
        int extra = this.autoLoadUsable || this.loadEnd || this.manualLoad ? 1 : 0;
        return this.getBodyCount() + extra;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (position < this.getBodyCount()) {
            this.onBodyBindViewHolder(viewHolder, position);
        } else if ((this.autoLoadUsable || this.loadEnd) && position + 1 == this.getItemCount()) {
            if (this.loadError) {
                viewHolder.itemView.setOnClickListener(this.mOnLastItemClickListener);
            } else if (this.loadEnd) {
                viewHolder.itemView.setOnClickListener(this.mEmptyClick);
            } else if (!this.manualLoad || this.loading) {
                if (!this.loading && this.mOnAutoLoadListener != null) {
                    this.mOnAutoLoadListener.onLoading();
                }
                viewHolder.itemView.setOnClickListener(this.mEmptyClick);
            } else {
                viewHolder.itemView.setOnClickListener(this.mOnLastItemClickListener);
            }
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (position < this.getBodyCount()) {
            return this.getBodyItemViewType(position);
        }
        if ((this.autoLoadUsable || this.loadEnd) && position + 1 == this.getItemCount()) {
            if (this.loadError) {
                return -3003;
            }
            if (this.loadEnd) {
                return -3004;
            }
            if (!this.manualLoad || this.loading) {
                return -3001;
            }
            return -3002;
        }
        return position - this.getBodyCount();
    }

    protected boolean isAutoLoadView(int viewType) {
        return viewType == -3001 || viewType == -3002 || viewType == -3003 || viewType == -3004;
    }

    @Override
    protected View getItemView(int layoutResId, ViewGroup parent) {
        if (this.mLayoutInflater == null) {
            this.mLayoutInflater = LayoutInflater.from((Context)parent.getContext());
        }
        return this.mLayoutInflater.inflate(layoutResId, parent, false);
    }

    public void setAutoLoadUsable(boolean display) {
        if (display == this.autoLoadUsable) {
            return;
        }
        this.autoLoadUsable = display;
        this.notifyDataSetChanged();
    }

    public boolean isAutoLoadUsable() {
        return this.autoLoadUsable;
    }

    public boolean isManualLoad() {
        return this.manualLoad;
    }

    public void setManualLoad(boolean manualLoad) {
        this.manualLoad = manualLoad;
    }

    public boolean isLoadError() {
        return this.loadError;
    }

    public void setLoadError(boolean loadError) {
        this.loadError = loadError;
    }

    public boolean isLoadEnd() {
        return this.loadEnd;
    }

    public void setLoadEnd(boolean loadEnd) {
        this.loadEnd = loadEnd;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public void setLoadingLayoutResId(int resId) {
        this.loadingLayoutResId = resId;
    }

    public int getLoadingLayoutResId() {
        return this.loadingLayoutResId;
    }

    public void setManualLayoutResId(int resId) {
        this.manualLayoutResId = resId;
    }

    public int getManualLayoutResId() {
        return this.manualLayoutResId;
    }

    public int getLoadEndLayoutResId() {
        return this.loadEndLayoutResId;
    }

    public void setLoadEndLayoutResId(int loadEndLayoutResId) {
        this.loadEndLayoutResId = loadEndLayoutResId;
    }

    public int getLoadErrorLayoutResId() {
        return this.loadErrorLayoutResId;
    }

    public void setLoadErrorLayoutResId(int loadErrorLayoutResId) {
        this.loadErrorLayoutResId = loadErrorLayoutResId;
    }

    public void setOnAutoLoadListener(OnAutoLoadListener listener) {
        this.mOnAutoLoadListener = listener;
    }

    public void setOnLastItemClickListener(View.OnClickListener listener) {
        this.mOnLastItemClickListener = listener;
    }

    public void onAutoLoadingError() {
        this.loadError = true;
        this.notifyDataSetChanged();
    }

    public void onAutoLoadStart() {
        this.manualLoad = false;
        this.loading = false;
        this.loadError = false;
        this.loadEnd = false;
        this.notifyDataSetChanged();
    }

    public void onAutoLoadFinished(boolean autoLoadUsable) {
        this.setLoading(false);
        if (!autoLoadUsable) {
            this.loadEnd = true;
            this.loadError = false;
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolve(Context context, int attr2, int defValue) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getResourceId(0, defValue);
            return n;
        }
        finally {
            a.recycle();
        }
    }
}

