/*
 * Decompiled with CFR 0.152.
 */
package com.eastwood.common.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.eastwood.common.adapter.BaseAdapterHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickAdapter<T, H extends BaseAdapterHelper>
extends BaseAdapter {
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected final Context context;
    protected final int layoutResId;
    protected final List<T> data;

    public BaseQuickAdapter() {
        this(null, 0, null);
    }

    public BaseQuickAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public BaseQuickAdapter(Context context, int layoutResId, List<T> data) {
        this.data = data == null ? new ArrayList() : data;
        this.context = context;
        this.layoutResId = layoutResId;
    }

    public int getCount() {
        return this.data.size();
    }

    public T getItem(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    public List<T> getData() {
        return this.data;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        return position >= this.data.size() ? 1 : 0;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        H helper = this.getAdapterHelper(position, convertView, parent);
        T item = this.getItem(position);
        this.convert(position, helper, item);
        return ((BaseAdapterHelper)helper).getView();
    }

    public boolean isEnabled(int position) {
        return position < this.data.size();
    }

    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    public void addAll(List<T> elem) {
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    public void set(T oldElem, T newElem) {
        this.set(this.data.indexOf(oldElem), newElem);
    }

    public void set(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
    }

    public void remove(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
    }

    public void replaceAll(List<T> elem) {
        this.data.clear();
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    public void clear() {
        this.data.clear();
        this.notifyDataSetChanged();
    }

    protected abstract void convert(int var1, H var2, T var3);

    protected abstract H getAdapterHelper(int var1, View var2, ViewGroup var3);
}

